/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.RelReferentialConstraintImpl;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.PartitionIterable;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.ParsedQueryTables;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelOptHiveTable
implements RelOptTable {
    private final RelOptSchema schema;
    private final RelDataTypeFactory typeFactory;
    private final RelDataType rowType;
    private final List<String> qualifiedTblName;
    private final String name;
    private final Table hiveTblMetadata;
    private final ImmutableList<ColumnInfo> hiveNonPartitionCols;
    private final ImmutableList<ColumnInfo> hivePartitionCols;
    private final Map<Integer, ColStatistics> hiveColStatsMap;
    private final ImmutableMap<Integer, ColumnInfo> hiveNonPartitionColsMap;
    private final ImmutableMap<Integer, ColumnInfo> hivePartitionColsMap;
    private final ImmutableList<VirtualColumn> hiveVirtualCols;
    private final int noOfNonVirtualCols;
    private final List<ImmutableBitSet> keys;
    private final List<ImmutableBitSet> nonNullablekeys;
    private List<RelReferentialConstraint> referentialConstraints;
    private boolean fetchedReferentialConstraints;
    private final HiveConf hiveConf;
    private final ParsedQueryTables tablesCache;
    private final Map<String, PrunedPartitionList> partitionCache;
    private final Map<String, ColumnStatsList> colStatsCache;
    private final AtomicInteger noColsMissingStats;
    private double rowCount = -1.0;
    PrunedPartitionList partitionList;
    protected static final Logger LOG = LoggerFactory.getLogger((String)RelOptHiveTable.class.getName());

    public RelOptHiveTable(RelOptSchema calciteSchema, RelDataTypeFactory typeFactory, List<String> qualifiedTblName, RelDataType rowType, Table hiveTblMetadata, List<ColumnInfo> hiveNonPartitionCols, List<ColumnInfo> hivePartitionCols, List<VirtualColumn> hiveVirtualCols, HiveConf hconf, ParsedQueryTables tabNameToTabObject, Map<String, PrunedPartitionList> partitionCache, Map<String, ColumnStatsList> colStatsCache, AtomicInteger noColsMissingStats) {
        this.schema = calciteSchema;
        this.typeFactory = typeFactory;
        this.qualifiedTblName = ImmutableList.copyOf(qualifiedTblName);
        this.name = this.qualifiedTblName.stream().collect(Collectors.joining("."));
        this.rowType = rowType;
        this.hiveTblMetadata = hiveTblMetadata;
        this.hiveColStatsMap = new HashMap<Integer, ColStatistics>();
        this.hiveNonPartitionCols = ImmutableList.copyOf(hiveNonPartitionCols);
        this.hiveNonPartitionColsMap = HiveCalciteUtil.getColInfoMap(hiveNonPartitionCols, 0);
        this.hivePartitionCols = ImmutableList.copyOf(hivePartitionCols);
        this.hivePartitionColsMap = HiveCalciteUtil.getColInfoMap(hivePartitionCols, this.hiveNonPartitionColsMap.size());
        this.noOfNonVirtualCols = hiveNonPartitionCols.size() + hivePartitionCols.size();
        this.hiveVirtualCols = ImmutableList.copyOf(hiveVirtualCols);
        this.hiveConf = hconf;
        this.tablesCache = tabNameToTabObject;
        this.partitionCache = partitionCache;
        this.colStatsCache = colStatsCache;
        this.noColsMissingStats = noColsMissingStats;
        Pair<List<ImmutableBitSet>, List<ImmutableBitSet>> constraintKeys = this.generateKeys();
        this.keys = (List)constraintKeys.left;
        this.nonNullablekeys = (List)constraintKeys.right;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getQualifiedName() {
        return this.qualifiedTblName;
    }

    public RelDataType getRowType() {
        return this.rowType;
    }

    public RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public Expression getExpression(Class clazz) {
        throw new UnsupportedOperationException();
    }

    public List<ImmutableBitSet> getNonNullableKeys() {
        return this.nonNullablekeys;
    }

    public RelOptTable extend(List<RelDataTypeField> extendedFields) {
        throw new UnsupportedOperationException();
    }

    public List<ColumnStrategy> getColumnStrategies() {
        return RelOptTableImpl.columnStrategies((RelOptTable)this);
    }

    public RelOptHiveTable copy(RelDataType newRowType) {
        HashMap<String, Integer> nameToColIndxMap = new HashMap<String, Integer>();
        for (RelDataTypeField f : this.rowType.getFieldList()) {
            nameToColIndxMap.put(f.getName(), f.getIndex());
        }
        ArrayList<ColumnInfo> newHiveNonPartitionCols = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> newHivePartitionCols = new ArrayList<ColumnInfo>();
        ArrayList<VirtualColumn> newHiveVirtualCols = new ArrayList<VirtualColumn>();
        ImmutableMap<Integer, VirtualColumn> virtualColInfoMap = HiveCalciteUtil.getVColsMap(this.hiveVirtualCols, this.noOfNonVirtualCols);
        for (RelDataTypeField f : newRowType.getFieldList()) {
            Integer originalColIndx = (Integer)nameToColIndxMap.get(f.getName());
            ColumnInfo cInfo = (ColumnInfo)this.hiveNonPartitionColsMap.get((Object)originalColIndx);
            if (cInfo != null) {
                newHiveNonPartitionCols.add(new ColumnInfo(cInfo));
                continue;
            }
            cInfo = (ColumnInfo)this.hivePartitionColsMap.get((Object)originalColIndx);
            if (cInfo != null) {
                newHivePartitionCols.add(new ColumnInfo(cInfo));
                continue;
            }
            VirtualColumn vc = (VirtualColumn)((Object)virtualColInfoMap.get(originalColIndx));
            if (vc != null) {
                newHiveVirtualCols.add(vc);
                continue;
            }
            throw new RuntimeException("Copy encountered a column not seen in original TS");
        }
        return new RelOptHiveTable(this.schema, this.typeFactory, this.qualifiedTblName, newRowType, this.hiveTblMetadata, newHiveNonPartitionCols, newHivePartitionCols, newHiveVirtualCols, this.hiveConf, this.tablesCache, this.partitionCache, this.colStatsCache, this.noColsMissingStats);
    }

    public boolean isNonNullableKey(ImmutableBitSet columns) {
        for (ImmutableBitSet key : this.nonNullablekeys) {
            if (!columns.contains(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isKey(ImmutableBitSet columns) {
        for (ImmutableBitSet key : this.keys) {
            if (!columns.contains(key)) continue;
            return true;
        }
        return false;
    }

    public boolean hasReferentialConstraints() {
        ForeignKeyInfo foreignKeyInfo = this.hiveTblMetadata.getForeignKeyInfo();
        return foreignKeyInfo != null && !foreignKeyInfo.getForeignKeys().isEmpty();
    }

    public List<ImmutableBitSet> getKeys() {
        return this.keys;
    }

    public List<RelReferentialConstraint> getReferentialConstraints() {
        if (!this.fetchedReferentialConstraints) {
            this.referentialConstraints = this.generateReferentialConstraints();
            this.fetchedReferentialConstraints = true;
        }
        return this.referentialConstraints;
    }

    private Pair<List<ImmutableBitSet>, List<ImmutableBitSet>> generateKeys() {
        PrimaryKeyInfo primaryKeyInfo = this.hiveTblMetadata.getPrimaryKeyInfo();
        UniqueConstraint uniqueKeyInfo = this.hiveTblMetadata.getUniqueKeyInfo();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder nonNullBuilder = ImmutableList.builder();
        if (primaryKeyInfo != null && !primaryKeyInfo.getColNames().isEmpty()) {
            ImmutableBitSet.Builder keys = ImmutableBitSet.builder();
            for (String pkColName : primaryKeyInfo.getColNames().values()) {
                Object colName;
                int pkPos;
                for (pkPos = 0; pkPos < this.rowType.getFieldNames().size() && !pkColName.equals(colName = (String)this.rowType.getFieldNames().get(pkPos)); ++pkPos) {
                }
                if (pkPos == this.rowType.getFieldNames().size()) {
                    LOG.error("Column for primary key definition " + pkColName + " not found");
                }
                keys.set(pkPos);
            }
            ImmutableBitSet key = keys.build();
            builder.add((Object)key);
            nonNullBuilder.add((Object)key);
        }
        if (uniqueKeyInfo != null && !uniqueKeyInfo.getUniqueConstraints().isEmpty()) {
            for (List<UniqueConstraint.UniqueConstraintCol> ukCols : uniqueKeyInfo.getUniqueConstraints().values()) {
                ImmutableBitSet.Builder keys = ImmutableBitSet.builder();
                boolean isNonNullable = true;
                for (UniqueConstraint.UniqueConstraintCol ukCol : ukCols) {
                    int ukPos;
                    for (ukPos = 0; ukPos < this.rowType.getFieldNames().size(); ++ukPos) {
                        String colName = (String)this.rowType.getFieldNames().get(ukPos);
                        if (!ukCol.colName.equals(colName)) continue;
                        if (!((RelDataTypeField)this.rowType.getFieldList().get(ukPos)).getType().isNullable()) break;
                        isNonNullable = false;
                        break;
                    }
                    if (ukPos == this.rowType.getFieldNames().size()) {
                        LOG.error("Column for unique constraint definition " + ukCol.colName + " not found");
                    }
                    keys.set(ukPos);
                }
                ImmutableBitSet key = keys.build();
                builder.add((Object)key);
                if (!isNonNullable) continue;
                nonNullBuilder.add((Object)key);
            }
        }
        return new Pair((Object)builder.build(), (Object)nonNullBuilder.build());
    }

    private List<RelReferentialConstraint> generateReferentialConstraints() {
        ForeignKeyInfo foreignKeyInfo = this.hiveTblMetadata.getForeignKeyInfo();
        ImmutableList.Builder builder = ImmutableList.builder();
        if (foreignKeyInfo != null && !foreignKeyInfo.getForeignKeys().isEmpty()) {
            for (List<ForeignKeyInfo.ForeignKeyCol> fkCols : foreignKeyInfo.getForeignKeys().values()) {
                String qualifiedName;
                String parentDatabaseName = fkCols.get((int)0).parentDatabaseName;
                String parentTableName = fkCols.get((int)0).parentTableName;
                ArrayList<String> parentTableQualifiedName = new ArrayList<String>();
                if (parentDatabaseName != null && !parentDatabaseName.isEmpty()) {
                    parentTableQualifiedName.add(parentDatabaseName);
                    parentTableQualifiedName.add(parentTableName);
                    qualifiedName = TableName.getDbTable((String)parentDatabaseName, (String)parentTableName);
                } else {
                    parentTableQualifiedName.add(parentTableName);
                    qualifiedName = parentTableName;
                }
                Table parentTab = this.tablesCache.getParsedTable(qualifiedName);
                if (parentTab == null) continue;
                ImmutableList.Builder keys = ImmutableList.builder();
                for (ForeignKeyInfo.ForeignKeyCol fkCol : fkCols) {
                    String pkColName;
                    int pkPos;
                    String fkColName;
                    int fkPos;
                    for (fkPos = 0; fkPos < this.rowType.getFieldNames().size() && !(fkColName = (String)this.rowType.getFieldNames().get(fkPos)).equals(fkCol.childColName); ++fkPos) {
                    }
                    for (pkPos = 0; pkPos < parentTab.getAllCols().size() && !(pkColName = parentTab.getAllCols().get(pkPos).getName()).equals(fkCol.parentColName); ++pkPos) {
                    }
                    if (fkPos == this.rowType.getFieldNames().size() || pkPos == parentTab.getAllCols().size()) {
                        LOG.error("Column for foreign key definition " + String.valueOf(fkCol) + " not found");
                        continue;
                    }
                    keys.add((Object)IntPair.of((int)fkPos, (int)pkPos));
                }
                builder.add((Object)RelReferentialConstraintImpl.of(this.qualifiedTblName, parentTableQualifiedName, (List)keys.build()));
            }
        }
        return builder.build();
    }

    public RelNode toRel(RelOptTable.ToRelContext context) {
        return new LogicalTableScan(context.getCluster(), (RelOptTable)this);
    }

    public <T> T unwrap(Class<T> arg0) {
        return arg0.isInstance(this) ? (T)arg0.cast(this) : null;
    }

    public List<RelCollation> getCollationList() {
        ImmutableList.Builder collationList = new ImmutableList.Builder();
        block0: for (Order sortColumn : this.hiveTblMetadata.getSortCols()) {
            for (int i = 0; i < this.hiveTblMetadata.getSd().getCols().size(); ++i) {
                FieldSchema field = (FieldSchema)this.hiveTblMetadata.getSd().getCols().get(i);
                if (!field.getName().equals(sortColumn.getCol())) continue;
                RelFieldCollation.Direction direction = DirectionUtils.codeToDirection(sortColumn.getOrder());
                RelFieldCollation.NullDirection nullDirection = sortColumn.getOrder() == 1 ? RelFieldCollation.NullDirection.FIRST : RelFieldCollation.NullDirection.LAST;
                collationList.add((Object)new RelFieldCollation(i, direction, nullDirection));
                continue block0;
            }
        }
        return new ImmutableList.Builder().add((Object)((RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)new HiveRelCollation((ImmutableList<RelFieldCollation>)collationList.build())))).build();
    }

    public RelDistribution getDistribution() {
        ImmutableList.Builder columnPositions = new ImmutableList.Builder();
        block0: for (String bucketColumn : this.hiveTblMetadata.getBucketCols()) {
            for (int i = 0; i < this.hiveTblMetadata.getSd().getCols().size(); ++i) {
                FieldSchema field = (FieldSchema)this.hiveTblMetadata.getSd().getCols().get(i);
                if (!field.getName().equals(bucketColumn)) continue;
                columnPositions.add((Object)i);
                continue block0;
            }
        }
        return new HiveRelDistribution(RelDistribution.Type.HASH_DISTRIBUTED, (List<Integer>)columnPositions.build());
    }

    public void setRowCount(double rowCount) {
        this.rowCount = rowCount;
    }

    public double getRowCount() {
        if (this.rowCount == -1.0) {
            if (null == this.partitionList) {
                this.computePartitionList(this.hiveConf, null, new HashSet<Integer>());
            }
            this.rowCount = StatsUtils.getNumRows(this.hiveConf, this.getNonPartColumns(), this.hiveTblMetadata, this.partitionList, this.noColsMissingStats);
        }
        return this.rowCount;
    }

    public Table getHiveTableMD() {
        return this.hiveTblMetadata;
    }

    private String getColNamesForLogging(Set<String> colLst) {
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        for (String colName : colLst) {
            if (firstEntry) {
                sb.append(colName);
                firstEntry = false;
                continue;
            }
            sb.append(", " + colName);
        }
        return sb.toString();
    }

    public void computePartitionList(HiveConf conf, RexNode pruneNode, Set<Integer> partOrVirtualCols) {
        try {
            if (!this.hiveTblMetadata.isPartitioned() || pruneNode == null || RelOptUtil.InputFinder.bits((RexNode)pruneNode).length() == 0) {
                this.partitionList = PartitionPruner.prune(this.hiveTblMetadata, null, conf, this.getName(), this.partitionCache);
                return;
            }
            ExprNodeDesc pruneExpr = (ExprNodeDesc)pruneNode.accept((RexVisitor)new ExprNodeConverter(this.getName(), this.getRowType(), partOrVirtualCols, this.getTypeFactory()));
            this.partitionList = PartitionPruner.prune(this.hiveTblMetadata, pruneExpr, conf, this.getName(), this.partitionCache);
        }
        catch (HiveException he) {
            throw new RuntimeException(he);
        }
    }

    private void updateColStats(Set<Integer> projIndxLst, boolean allowMissingStats) {
        String partitionListKey;
        ColumnStatsList colStatsCached;
        ArrayList<String> nonPartColNamesThatRqrStats = new ArrayList<String>();
        ArrayList<Integer> nonPartColIndxsThatRqrStats = new ArrayList<Integer>();
        ArrayList<String> partColNamesThatRqrStats = new ArrayList<String>();
        ArrayList<Integer> partColIndxsThatRqrStats = new ArrayList<Integer>();
        HashSet<String> colNamesFailedStats = new HashSet<String>();
        for (Integer pi : projIndxLst) {
            if (this.hiveColStatsMap.get(pi) != null) continue;
            ColumnInfo tmp = (ColumnInfo)this.hiveNonPartitionColsMap.get((Object)pi);
            if (tmp != null) {
                nonPartColNamesThatRqrStats.add(tmp.getInternalName());
                nonPartColIndxsThatRqrStats.add(pi);
                continue;
            }
            tmp = (ColumnInfo)this.hivePartitionColsMap.get((Object)pi);
            if (tmp != null) {
                partColNamesThatRqrStats.add(tmp.getInternalName());
                partColIndxsThatRqrStats.add(pi);
                continue;
            }
            this.noColsMissingStats.getAndIncrement();
            String logMsg = "Unable to find Column Index: " + pi + ", in " + this.hiveTblMetadata.getCompleteName();
            LOG.error(logMsg);
            throw new RuntimeException(logMsg);
        }
        if (null == this.partitionList) {
            this.computePartitionList(this.hiveConf, null, new HashSet<Integer>());
        }
        if ((colStatsCached = this.colStatsCache.get(partitionListKey = (String)this.partitionList.getKey().orElse(null))) == null) {
            colStatsCached = new ColumnStatsList();
            this.colStatsCache.put(partitionListKey, colStatsCached);
        }
        if (nonPartColNamesThatRqrStats.size() > 0) {
            ArrayList<ColStatistics> hiveColStats = new ArrayList<ColStatistics>();
            if (!this.hiveTblMetadata.isPartitioned()) {
                try {
                    Statistics stats = StatsUtils.collectStatistics(this.hiveConf, null, this.hiveTblMetadata, this.hiveNonPartitionCols, nonPartColNamesThatRqrStats, colStatsCached, nonPartColNamesThatRqrStats, true);
                    this.rowCount = stats.getNumRows();
                    for (String c : nonPartColNamesThatRqrStats) {
                        ColStatistics colStatistics = stats.getColumnStatisticsFromColName(c);
                        if (colStatistics == null) continue;
                        hiveColStats.add(colStatistics);
                    }
                    colStatsCached.updateState(stats.getColumnStatsState());
                    if (hiveColStats.isEmpty()) {
                        colNamesFailedStats.addAll(nonPartColNamesThatRqrStats);
                    }
                    if (hiveColStats.size() != nonPartColNamesThatRqrStats.size()) {
                        HashSet<String> setOfFiledCols = new HashSet<String>(nonPartColNamesThatRqrStats);
                        Iterator<String> setOfObtainedColStats = new HashSet();
                        for (ColStatistics cs : hiveColStats) {
                            setOfObtainedColStats.add(cs.getColumnName());
                        }
                        setOfFiledCols.removeAll((Collection<?>)((Object)setOfObtainedColStats));
                        colNamesFailedStats.addAll(setOfFiledCols);
                    }
                    HashMap<String, ColStatistics> columnStatsMap = new HashMap<String, ColStatistics>(hiveColStats.size());
                    for (ColStatistics colStatistics : hiveColStats) {
                        columnStatsMap.put(colStatistics.getColumnName(), colStatistics);
                        if (!colStatistics.isEstimated()) continue;
                        colNamesFailedStats.add(colStatistics.getColumnName());
                    }
                    hiveColStats.clear();
                    for (String string : nonPartColNamesThatRqrStats) {
                        hiveColStats.add((ColStatistics)columnStatsMap.get(string));
                    }
                }
                catch (HiveException e) {
                    String logMsg = "Collecting stats for table: " + this.hiveTblMetadata.getTableName() + " failed.";
                    LOG.error(logMsg, (Throwable)e);
                    throw new RuntimeException(logMsg, e);
                }
            } else {
                try {
                    if (this.partitionList.getNotDeniedPartns().isEmpty()) {
                        this.rowCount = 0.0;
                        hiveColStats = new ArrayList();
                        for (int i = 0; i < nonPartColNamesThatRqrStats.size(); ++i) {
                            hiveColStats.add(new ColStatistics((String)nonPartColNamesThatRqrStats.get(i), ((ColumnInfo)this.hiveNonPartitionColsMap.get(nonPartColIndxsThatRqrStats.get(i))).getTypeName()));
                        }
                        colNamesFailedStats.clear();
                        colStatsCached.updateState(Statistics.State.COMPLETE);
                    } else {
                        Statistics stats = StatsUtils.collectStatistics(this.hiveConf, this.partitionList, this.hiveTblMetadata, this.hiveNonPartitionCols, nonPartColNamesThatRqrStats, colStatsCached, nonPartColNamesThatRqrStats, true);
                        this.rowCount = stats.getNumRows();
                        hiveColStats = new ArrayList();
                        for (String c : nonPartColNamesThatRqrStats) {
                            ColStatistics colStatistics = stats.getColumnStatisticsFromColName(c);
                            if (colStatistics != null) {
                                hiveColStats.add(colStatistics);
                                if (!colStatistics.isEstimated()) continue;
                                colNamesFailedStats.add(c);
                                continue;
                            }
                            colNamesFailedStats.add(c);
                        }
                        colStatsCached.updateState(stats.getColumnStatsState());
                    }
                }
                catch (HiveException e) {
                    String logMsg = "Collecting stats failed.";
                    LOG.error(logMsg, (Throwable)e);
                    throw new RuntimeException(logMsg, e);
                }
            }
            if (hiveColStats != null && hiveColStats.size() == nonPartColNamesThatRqrStats.size()) {
                for (int i = 0; i < hiveColStats.size(); ++i) {
                    this.hiveColStatsMap.put((Integer)nonPartColIndxsThatRqrStats.get(i), (ColStatistics)hiveColStats.get(i));
                    colStatsCached.put(((ColStatistics)hiveColStats.get(i)).getColumnName(), (ColStatistics)hiveColStats.get(i));
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Stats for column " + ((ColStatistics)hiveColStats.get(i)).getColumnName() + " in table " + this.hiveTblMetadata.getTableName() + " stored in cache");
                    LOG.debug(((ColStatistics)hiveColStats.get(i)).toString());
                }
            }
        }
        if (colNamesFailedStats.isEmpty() && !partColNamesThatRqrStats.isEmpty()) {
            ColStatistics cStats = null;
            for (int i = 0; i < partColNamesThatRqrStats.size(); ++i) {
                cStats = StatsUtils.getColStatsForPartCol((ColumnInfo)this.hivePartitionColsMap.get(partColIndxsThatRqrStats.get(i)), new PartitionIterable(this.partitionList.getNotDeniedPartns()), this.hiveConf);
                this.hiveColStatsMap.put((Integer)partColIndxsThatRqrStats.get(i), cStats);
                colStatsCached.put(cStats.getColumnName(), cStats);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Stats for column " + cStats.getColumnName() + " in table " + this.hiveTblMetadata.getTableName() + " stored in cache");
                LOG.debug(cStats.toString());
            }
        }
        if (!colNamesFailedStats.isEmpty()) {
            String logMsg = "No Stats for " + this.hiveTblMetadata.getCompleteName() + ", Columns: " + this.getColNamesForLogging(colNamesFailedStats);
            this.noColsMissingStats.getAndAdd(colNamesFailedStats.size());
            if (allowMissingStats) {
                LOG.warn(logMsg);
                HiveConf conf = SessionState.getSessionConf();
                if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_SHOW_WARNINGS)) {
                    SessionState.LogHelper console = SessionState.getConsole();
                    console.printInfo(logMsg);
                }
            } else {
                LOG.error(logMsg);
                throw new RuntimeException(logMsg);
            }
        }
    }

    public List<ColStatistics> getColStat(List<Integer> projIndxLst) {
        return this.getColStat(projIndxLst, HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_ESTIMATE_STATS));
    }

    public List<ColStatistics> getColStat(List<Integer> projIndxLst, boolean allowMissingStats) {
        ArrayList colStatsBldr = Lists.newArrayList();
        HashSet<Integer> projIndxSet = new HashSet<Integer>(projIndxLst);
        for (Integer i : projIndxLst) {
            if (i >= this.noOfNonVirtualCols) {
                projIndxSet.remove(i);
                continue;
            }
            if (this.hiveColStatsMap.get(i) == null) continue;
            colStatsBldr.add(this.hiveColStatsMap.get(i));
            projIndxSet.remove(i);
        }
        if (!projIndxSet.isEmpty()) {
            LOG.info("Calculating column statistics for {}, projIndxSet: {}, allowMissingStats: {}", new Object[]{this.name, projIndxLst, allowMissingStats});
            this.updateColStats(projIndxSet, allowMissingStats);
            for (Integer i : projIndxSet) {
                colStatsBldr.add(this.hiveColStatsMap.get(i));
            }
        }
        return colStatsBldr;
    }

    public boolean containsPartitionColumnsOnly(ImmutableBitSet cols) {
        int i = cols.nextSetBit(0);
        while (i >= 0) {
            if (!this.hivePartitionColsMap.containsKey((Object)i)) {
                return false;
            }
            ++i;
            i = cols.nextSetBit(i + 1);
        }
        return true;
    }

    public List<VirtualColumn> getVirtualCols() {
        return this.hiveVirtualCols;
    }

    public List<ColumnInfo> getPartColumns() {
        return this.hivePartitionCols;
    }

    public List<ColumnInfo> getNonPartColumns() {
        return this.hiveNonPartitionCols;
    }

    public int getNoOfNonVirtualCols() {
        return this.noOfNonVirtualCols;
    }

    public Map<Integer, ColumnInfo> getPartColInfoMap() {
        return this.hivePartitionColsMap;
    }

    public Map<Integer, ColumnInfo> getNonPartColInfoMap() {
        return this.hiveNonPartitionColsMap;
    }

    public boolean equals(Object obj) {
        return obj instanceof RelOptHiveTable && this.rowType.equals((Object)((RelOptHiveTable)obj).getRowType()) && this.getHiveTableMD().equals(((RelOptHiveTable)obj).getHiveTableMD());
    }

    public int hashCode() {
        return this.getHiveTableMD() == null ? super.hashCode() : this.getHiveTableMD().hashCode();
    }

    public String getPartitionListKey() {
        return this.partitionList != null ? (String)this.partitionList.getKey().orElse(null) : null;
    }
}

