/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;

public class HiveFilterSortTransposeRule
extends RelOptRule {
    public static final HiveFilterSortTransposeRule SORT_LIMIT_INSTANCE = new HiveFilterSortTransposeRule(HiveSortLimit.class);
    public static final HiveFilterSortTransposeRule SORT_EXCHANGE_INSTANCE = new HiveFilterSortTransposeRule(HiveSortExchange.class);

    private HiveFilterSortTransposeRule(Class<? extends RelNode> clazz) {
        super(HiveFilterSortTransposeRule.operand(HiveFilter.class, (RelOptRuleOperand)HiveFilterSortTransposeRule.operand(clazz, (RelOptRuleOperandChildren)HiveFilterSortTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        RelNode sort = call.rel(1);
        return !HiveCalciteUtil.limitRelNode(sort);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveFilter filter = (HiveFilter)call.rel(0);
        RelNode sort = call.rel(1);
        RelNode newFilter = filter.copy(sort.getInput(0).getTraitSet(), (List)ImmutableList.of((Object)sort.getInput(0)));
        RelNode newSort = sort.copy(sort.getTraitSet(), Collections.singletonList(newFilter));
        call.transformTo(newSort);
    }
}

