/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.graph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.graph.DagGraph;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class OperatorGraph {
    private final DagGraph<Operator<?>, OpEdge> dagGraph;
    private final Set<Cluster> clusterSet;
    private final Map<Operator<?>, Set<Cluster>> operatorToCluster;

    private Cluster createCluster(Operator<?> rootOperator) {
        Cluster cluster = new Cluster();
        LinkedList remainingOperators = new LinkedList();
        remainingOperators.add(rootOperator);
        while (!remainingOperators.isEmpty()) {
            Operator currentOperator = (Operator)remainingOperators.poll();
            if (cluster.getMembers().contains(currentOperator)) continue;
            cluster.add(currentOperator);
            if (currentOperator instanceof ReduceSinkOperator) continue;
            remainingOperators.addAll(currentOperator.getChildOperators());
        }
        return cluster;
    }

    private Set<Cluster> createClusterSet(ParseContext pctx) {
        HashSet<TableScanOperator> rootOperators = new HashSet<TableScanOperator>(pctx.getTopOps().values());
        HashSet<Operator> joinOperators = new HashSet<Operator>();
        for (Operator operator : pctx.getAllOps()) {
            if (operator instanceof CommonJoinOperator) {
                if (operator instanceof MapJoinOperator) {
                    MapJoinDesc mapJoinDesc = (MapJoinDesc)operator.getConf();
                    if (mapJoinDesc.isDynamicPartitionHashJoin()) {
                        joinOperators.add(operator);
                    }
                } else {
                    joinOperators.add(operator);
                }
            }
            if (!(operator instanceof ReduceSinkOperator)) continue;
            for (Operator<OperatorDesc> operator2 : operator.getChildOperators()) {
                if (operator2 instanceof MapJoinOperator) {
                    MapJoinDesc conf = (MapJoinDesc)operator2.getConf();
                    if (!conf.isDynamicPartitionHashJoin()) continue;
                    rootOperators.add((TableScanOperator)operator2);
                    continue;
                }
                rootOperators.add((TableScanOperator)operator2);
            }
        }
        HashSet<Cluster> clusters = new HashSet<Cluster>();
        for (Operator operator : rootOperators) {
            clusters.add(this.createCluster(operator));
        }
        for (Operator operator : joinOperators) {
            HashSet<Cluster> hashSet = new HashSet<Cluster>();
            for (Cluster cluster : clusters) {
                if (!cluster.getMembers().contains(operator)) continue;
                hashSet.add(cluster);
            }
            if (hashSet.size() <= 1) continue;
            Cluster mergedCluster = new Cluster();
            for (Cluster cluster : hashSet) {
                mergedCluster.merge(cluster);
            }
            clusters.add(mergedCluster);
            clusters.removeAll(hashSet);
        }
        return clusters;
    }

    private DagGraph<Operator<?>, OpEdge> createDagGraph(ParseContext pctx) {
        DagGraph graph = new DagGraph();
        for (Operator operator : pctx.getAllOps()) {
            List<Operator<OperatorDesc>> parents = operator.getParentOperators();
            for (Operator<OperatorDesc> parentOperator : parents) {
                if (operator instanceof MapJoinOperator && parentOperator instanceof ReduceSinkOperator) {
                    graph.putEdgeValue(parentOperator, operator, new OpEdge(EdgeType.BROADCAST));
                    continue;
                }
                graph.putEdgeValue(parentOperator, operator, new OpEdge(EdgeType.FLOW));
            }
            SemiJoinBranchInfo sji = pctx.getRsToSemiJoinBranchInfo().get(operator);
            if (sji != null) {
                graph.putEdgeValue(operator, sji.getTsOp(), new OpEdge(EdgeType.SEMIJOIN));
            }
            if (!(operator instanceof AppMasterEventOperator)) continue;
            DynamicPruningEventDesc dped = (DynamicPruningEventDesc)operator.getConf();
            TableScanOperator ts = dped.getTableScan();
            graph.putEdgeValue(operator, ts, new OpEdge(EdgeType.DPP));
        }
        return graph;
    }

    public OperatorGraph(ParseContext pctx) {
        this.dagGraph = this.createDagGraph(pctx);
        this.clusterSet = Collections.unmodifiableSet(this.createClusterSet(pctx));
        this.operatorToCluster = new HashMap();
        for (Cluster cluster : this.clusterSet) {
            for (Operator<?> operator : cluster.getMembers()) {
                this.operatorToCluster.computeIfAbsent(operator, o -> new HashSet()).add(cluster);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mayMerge(Operator<?> opA, Operator<?> opB) {
        try {
            this.dagGraph.putEdgeValue(opA, opB, new OpEdge(EdgeType.TEST));
            this.dagGraph.removeEdge(opA, opB);
            this.dagGraph.putEdgeValue(opB, opA, new OpEdge(EdgeType.TEST));
            this.dagGraph.removeEdge(opB, opA);
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException iae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.dagGraph.removeEdge(opA, opB);
            this.dagGraph.removeEdge(opB, opA);
        }
    }

    public Set<Cluster> clusterOf(Operator<?> operator) {
        return Collections.unmodifiableSet(this.operatorToCluster.get(operator));
    }

    public Set<Cluster> getClusters() {
        return this.clusterSet;
    }

    public DagGraph<Operator<?>, OpEdge> getDagGraph() {
        return this.dagGraph;
    }

    public class Cluster {
        private final Set<Operator<?>> members = new HashSet();

        public void add(Operator<?> operator) {
            this.members.add(operator);
        }

        public void merge(Cluster cluster) {
            this.members.addAll(cluster.getMembers());
        }

        public Set<Cluster> parentClusters(OperatorEdgePredicate traverseEdge) {
            HashSet<Cluster> ret = new HashSet<Cluster>();
            for (Operator<?> operator : this.members) {
                Stream<Operator> foreignParentOperators = OperatorGraph.this.dagGraph.predecessors(operator).stream().filter(pOp -> !this.members.contains(pOp)).filter(pOp -> traverseEdge.accept((Operator<?>)pOp, operator, (OpEdge)OperatorGraph.this.dagGraph.getEdge((Operator<?>)pOp, operator).get()));
                foreignParentOperators.forEach(parentOperator -> {
                    for (Cluster parentCluster : OperatorGraph.this.operatorToCluster.get(parentOperator)) {
                        if (parentCluster.getMembers().contains(operator)) continue;
                        ret.add(parentCluster);
                    }
                });
            }
            return ret;
        }

        public Set<Cluster> childClusters(OperatorEdgePredicate traverseEdge) {
            HashSet<Cluster> ret = new HashSet<Cluster>();
            for (Operator<?> operator : this.members) {
                Stream<Operator> foreignChildOperators = OperatorGraph.this.dagGraph.successors(operator).stream().filter(cOp -> !this.members.contains(cOp)).filter(cOp -> traverseEdge.accept(operator, (Operator<?>)cOp, (OpEdge)OperatorGraph.this.dagGraph.getEdge(operator, (Operator<?>)cOp).get()));
                foreignChildOperators.forEach(childOperator -> {
                    for (Cluster childCluster : OperatorGraph.this.operatorToCluster.get(childOperator)) {
                        if (childCluster.getMembers().contains(operator)) continue;
                        ret.add(childCluster);
                    }
                });
            }
            return ret;
        }

        public Set<Operator<?>> getMembers() {
            return Collections.unmodifiableSet(this.members);
        }
    }

    public static class OpEdge {
        private final EdgeType et;

        public OpEdge(EdgeType et) {
            this.et = et;
        }

        public EdgeType getEdgeType() {
            return this.et;
        }
    }

    public static enum EdgeType {
        FLOW,
        SEMIJOIN,
        DPP,
        TEST,
        BROADCAST;

    }

    public static interface OperatorEdgePredicate {
        public boolean accept(Operator<?> var1, Operator<?> var2, OpEdge var3);
    }
}

