/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.Utils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.lineage.ExprProcFactory;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.ptf.Noop;

public class OpProcFactory {
    protected static Operator<? extends OperatorDesc> getParent(Stack<Node> stack) {
        return (Operator)Utils.getNthAncestor(stack, 1);
    }

    public static SemanticNodeProcessor getJoinProc() {
        return new JoinLineage();
    }

    public static SemanticNodeProcessor getLateralViewJoinProc() {
        return new LateralViewJoinLineage();
    }

    public static SemanticNodeProcessor getTSProc() {
        return new TableScanLineage();
    }

    public static SemanticNodeProcessor getTransformProc() {
        return new TransformLineage();
    }

    public static SemanticNodeProcessor getSelProc() {
        return new SelectLineage();
    }

    public static SemanticNodeProcessor getGroupByProc() {
        return new GroupByLineage();
    }

    public static SemanticNodeProcessor getUnionProc() {
        return new UnionLineage();
    }

    public static SemanticNodeProcessor getReduceSinkProc() {
        return new ReduceSinkLineage();
    }

    public static SemanticNodeProcessor getDefaultProc() {
        return new DefaultLineage();
    }

    public static SemanticNodeProcessor getFilterProc() {
        return new FilterLineage();
    }

    public static SemanticNodeProcessor getPTFProc() {
        return new PTFLineage();
    }

    public static class JoinLineage
    extends DefaultLineage
    implements SemanticNodeProcessor {
        private final HashMap<Node, Object> outputMap = new HashMap();

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            JoinOperator op = (JoinOperator)nd;
            JoinDesc jd = (JoinDesc)op.getConf();
            ReduceSinkOperator inpOp = (ReduceSinkOperator)OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            LineageInfo.Predicate cond = this.getPredicate(op, lCtx);
            if (cond != null) {
                lCtx.getIndex().addPredicate(op, cond);
            }
            ReduceSinkDesc rd = (ReduceSinkDesc)inpOp.getConf();
            int tag = rd.getTag();
            int cnt = 0;
            List<ExprNodeDesc> exprs = jd.getExprs().get((byte)tag);
            for (ColumnInfo ci : op.getSchema().getSignature()) {
                if (jd.getReversedExprs().get(ci.getInternalName()) != tag) continue;
                ExprNodeDesc expr = exprs.get(cnt++);
                LineageInfo.Dependency dependency = ExprProcFactory.getExprDependency(lCtx, inpOp, expr, this.outputMap);
                lCtx.getIndex().mergeDependency(op, ci, dependency);
            }
            return null;
        }

        private LineageInfo.Predicate getPredicate(JoinOperator jop, LineageCtx lctx) {
            List<Operator<OperatorDesc>> parentOperators = jop.getParentOperators();
            JoinDesc jd = (JoinDesc)jop.getConf();
            ExprNodeDesc[][] joinKeys = jd.getJoinKeys();
            if (joinKeys == null || parentOperators == null || parentOperators.size() < 2) {
                return null;
            }
            LineageCtx.Index index = lctx.getIndex();
            for (Operator<OperatorDesc> op : parentOperators) {
                if (index.getDependencies(op) != null) continue;
                return null;
            }
            LineageInfo.Predicate cond = new LineageInfo.Predicate();
            JoinCondDesc[] conds = jd.getConds();
            int parents = parentOperators.size();
            StringBuilder sb = new StringBuilder("(");
            for (int i = 0; i < conds.length; ++i) {
                if (i != 0) {
                    sb.append(" AND ");
                }
                int left = conds[i].getLeft();
                int right = conds[i].getRight();
                if (joinKeys.length <= left || joinKeys[left].length == 0 || joinKeys.length <= right || joinKeys[right].length == 0 || parents < left || parents < right) {
                    return null;
                }
                ExprNodeDesc expr = joinKeys[left][0];
                Operator<OperatorDesc> op = parentOperators.get(left);
                List<Operator<OperatorDesc>> p = op.getParentOperators();
                if (p == null || p.isEmpty()) {
                    return null;
                }
                sb.append(ExprProcFactory.getExprString(op.getSchema(), expr, lctx, p.get(0), cond));
                sb.append(" = ");
                expr = joinKeys[right][0];
                op = parentOperators.get(right);
                p = op.getParentOperators();
                if (p == null || p.isEmpty()) {
                    return null;
                }
                sb.append(ExprProcFactory.getExprString(op.getSchema(), expr, lctx, p.get(0), cond));
            }
            sb.append(")");
            cond.setExpr(sb.toString());
            return cond;
        }
    }

    public static class LateralViewJoinLineage
    extends DefaultLineage
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            LateralViewJoinOperator op = (LateralViewJoinOperator)nd;
            boolean isUdtfPath = true;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            List<ColumnInfo> cols = inpOp.getSchema().getSignature();
            lCtx.getIndex().copyPredicates(inpOp, op);
            if (inpOp instanceof SelectOperator) {
                isUdtfPath = false;
            }
            List<ColumnInfo> outCols = op.getSchema().getSignature();
            int outColsSize = outCols.size();
            int colsSize = cols.size();
            int outColOffset = isUdtfPath ? outColsSize - colsSize : 0;
            for (int cnt = 0; cnt < colsSize; ++cnt) {
                ColumnInfo outCol = outCols.get(outColOffset + cnt);
                if (outCol.isHiddenVirtualCol()) continue;
                ColumnInfo col = cols.get(cnt);
                lCtx.getIndex().mergeDependency(op, outCol, lCtx.getIndex().getDependency(inpOp, col));
            }
            return null;
        }
    }

    public static class TableScanLineage
    extends DefaultLineage
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lCtx = (LineageCtx)procCtx;
            ParseContext pctx = lCtx.getParseCtx();
            TableScanOperator top = (TableScanOperator)nd;
            Table t = ((TableScanDesc)top.getConf()).getTableMetadata();
            org.apache.hadoop.hive.metastore.api.Table tab = t.getTTable();
            RowSchema rs = top.getSchema();
            List<FieldSchema> cols = t.getAllCols();
            HashMap<String, FieldSchema> fieldSchemaMap = new HashMap<String, FieldSchema>();
            for (FieldSchema col : cols) {
                fieldSchemaMap.put(col.getName(), col);
            }
            for (VirtualColumn vc : VirtualColumn.getRegistry()) {
                fieldSchemaMap.put(vc.getName(), new FieldSchema(vc.getName(), vc.getTypeInfo().getTypeName(), ""));
            }
            LineageInfo.TableAliasInfo tai = new LineageInfo.TableAliasInfo();
            tai.setAlias(((TableScanDesc)top.getConf()).getAlias());
            tai.setTable(tab);
            for (ColumnInfo ci : rs.getSignature()) {
                LineageInfo.Dependency dep = new LineageInfo.Dependency();
                LineageInfo.BaseColumnInfo bci = new LineageInfo.BaseColumnInfo();
                bci.setTabAlias(tai);
                bci.setColumn((FieldSchema)fieldSchemaMap.get(ci.getInternalName()));
                dep.setType(LineageInfo.DependencyType.SIMPLE);
                dep.setBaseCols(new LinkedHashSet<LineageInfo.BaseColumnInfo>());
                dep.getBaseCols().add(bci);
                lCtx.getIndex().putDependency(top, ci, dep);
            }
            return null;
        }
    }

    public static class TransformLineage
    extends DefaultLineage
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            LineageInfo.Dependency dep = new LineageInfo.Dependency();
            LineageInfo.DependencyType newType = LineageInfo.DependencyType.SCRIPT;
            dep.setType(LineageInfo.DependencyType.SCRIPT);
            dep.setExpr(null);
            LinkedHashSet<LineageInfo.BaseColumnInfo> colSet = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
            for (ColumnInfo ci : inpOp.getSchema().getSignature()) {
                LineageInfo.Dependency d = lCtx.getIndex().getDependency(inpOp, ci);
                if (d == null) continue;
                newType = LineageCtx.getNewDependencyType(d.getType(), newType);
                if (ci.isHiddenVirtualCol()) continue;
                colSet.addAll(d.getBaseCols());
            }
            dep.setType(newType);
            dep.setBaseCols(colSet);
            boolean isScript = op instanceof ScriptOperator;
            for (ColumnInfo ci : op.getSchema().getSignature()) {
                LineageInfo.Dependency depCi;
                LineageInfo.Dependency d = dep;
                if (!isScript && (depCi = lCtx.getIndex().getDependency(inpOp, ci)) != null) {
                    d = depCi;
                }
                lCtx.getIndex().putDependency(op, ci, d);
            }
            return null;
        }
    }

    public static class SelectLineage
    extends DefaultLineage
    implements SemanticNodeProcessor {
        private final HashMap<Node, Object> outputMap = new HashMap();

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lctx = (LineageCtx)procCtx;
            SelectOperator sop = (SelectOperator)nd;
            if (((SelectDesc)sop.getConf()).isSelStarNoCompute()) {
                return super.process(nd, stack, procCtx, nodeOutputs);
            }
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lctx.getIndex().copyPredicates(inpOp, sop);
            RowSchema rs = sop.getSchema();
            List<ColumnInfo> colInfos = rs.getSignature();
            int cnt = 0;
            for (ExprNodeDesc expr : ((SelectDesc)sop.getConf()).getColList()) {
                LineageInfo.Dependency dep = ExprProcFactory.getExprDependency(lctx, inpOp, expr, this.outputMap);
                if (dep != null && dep.getExpr() == null && (dep.getBaseCols().isEmpty() || dep.getType() != LineageInfo.DependencyType.SIMPLE)) {
                    dep.setExpr(ExprProcFactory.getExprString(rs, expr, lctx, inpOp, null));
                }
                lctx.getIndex().putDependency(sop, colInfos.get(cnt++), dep);
            }
            Operator<OperatorDesc> op = null;
            if (!sop.getChildOperators().isEmpty() && !(op = sop.getChildOperators().get(0)).getChildOperators().isEmpty() && op instanceof LimitOperator) {
                op = op.getChildOperators().get(0);
            }
            if (op == null || op.getChildOperators().isEmpty() && op instanceof FileSinkOperator) {
                lctx.getIndex().addFinalSelectOp(sop, op);
            }
            return null;
        }
    }

    public static class GroupByLineage
    extends DefaultLineage
    implements SemanticNodeProcessor {
        private final HashMap<Node, Object> outputMap = new HashMap();

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageCtx lctx = (LineageCtx)procCtx;
            GroupByOperator gop = (GroupByOperator)nd;
            List<ColumnInfo> colInfos = gop.getSchema().getSignature();
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lctx.getIndex().copyPredicates(inpOp, gop);
            int cnt = 0;
            for (ExprNodeDesc expr : ((GroupByDesc)gop.getConf()).getKeys()) {
                lctx.getIndex().putDependency(gop, colInfos.get(cnt++), ExprProcFactory.getExprDependency(lctx, inpOp, expr, this.outputMap));
            }
            boolean reduceSideGop = inpOp instanceof ReduceSinkOperator && Utils.getNthAncestor(stack, 2) instanceof GroupByOperator;
            RowSchema rs = gop.getSchema();
            for (AggregationDesc agg : ((GroupByDesc)gop.getConf()).getAggregators()) {
                LineageInfo.Dependency dep = new LineageInfo.Dependency();
                LineageInfo.DependencyType newType = LineageInfo.DependencyType.EXPRESSION;
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                LinkedHashSet<LineageInfo.BaseColumnInfo> bciSet = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
                for (ExprNodeDesc expr : agg.getParameters()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    LineageInfo.Dependency exprDep = ExprProcFactory.getExprDependency(lctx, inpOp, expr, this.outputMap);
                    if (exprDep != null && !exprDep.getBaseCols().isEmpty()) {
                        newType = LineageCtx.getNewDependencyType(exprDep.getType(), newType);
                        bciSet.addAll(exprDep.getBaseCols());
                        if (exprDep.getType() == LineageInfo.DependencyType.SIMPLE) {
                            LineageInfo.BaseColumnInfo col = exprDep.getBaseCols().iterator().next();
                            org.apache.hadoop.hive.metastore.api.Table t = col.getTabAlias().getTable();
                            if (t != null) {
                                sb.append(Warehouse.getQualifiedName((org.apache.hadoop.hive.metastore.api.Table)t)).append(".");
                            }
                            sb.append(col.getColumn().getName());
                        }
                    }
                    if (exprDep != null && !exprDep.getBaseCols().isEmpty() && exprDep.getType() == LineageInfo.DependencyType.SIMPLE) continue;
                    sb.append(exprDep != null && exprDep.getExpr() != null ? exprDep.getExpr() : ExprProcFactory.getExprString(rs, expr, lctx, inpOp, null));
                }
                String expr = sb.toString();
                String udafName = agg.getGenericUDAFName();
                if (!reduceSideGop || !expr.startsWith(udafName)) {
                    sb.setLength(0);
                    sb.append(udafName);
                    sb.append("(");
                    if (agg.getDistinct()) {
                        sb.append("DISTINCT ");
                    }
                    sb.append(expr);
                    if (first) {
                        sb.append("*");
                    }
                    sb.append(")");
                    expr = sb.toString();
                }
                dep.setExpr(expr);
                if (bciSet.isEmpty()) {
                    LinkedHashSet<LineageInfo.TableAliasInfo> taiSet = new LinkedHashSet<LineageInfo.TableAliasInfo>();
                    if (inpOp.getSchema() != null && inpOp.getSchema().getSignature() != null) {
                        for (ColumnInfo ci : inpOp.getSchema().getSignature()) {
                            LineageInfo.Dependency inpDep = lctx.getIndex().getDependency(inpOp, ci);
                            if (inpDep == null) continue;
                            for (LineageInfo.BaseColumnInfo bci : inpDep.getBaseCols()) {
                                newType = LineageCtx.getNewDependencyType(inpDep.getType(), newType);
                                taiSet.add(bci.getTabAlias());
                            }
                        }
                    }
                    for (LineageInfo.TableAliasInfo tai : taiSet) {
                        LineageInfo.BaseColumnInfo bci = new LineageInfo.BaseColumnInfo();
                        bci.setTabAlias(tai);
                        bci.setColumn(null);
                        bciSet.add(bci);
                    }
                }
                dep.setBaseCols(bciSet);
                dep.setType(newType);
                lctx.getIndex().putDependency(gop, colInfos.get(cnt++), dep);
            }
            return null;
        }
    }

    public static class UnionLineage
    extends DefaultLineage
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            RowSchema rs = op.getSchema();
            List<ColumnInfo> inpCols = inpOp.getSchema().getSignature();
            for (ColumnInfo input : inpCols) {
                LineageInfo.Dependency inpDep = lCtx.getIndex().getDependency(inpOp, input);
                if (inpDep == null) continue;
                ColumnInfo ci = rs.getColumnInfo(input.getInternalName());
                lCtx.getIndex().mergeDependency(op, ci, inpDep);
            }
            return null;
        }
    }

    public static class ReduceSinkLineage
    implements SemanticNodeProcessor {
        private final HashMap<Node, Object> outputMap = new HashMap();

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            ReduceSinkOperator rop = (ReduceSinkOperator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, rop);
            int cnt = 0;
            Operator<OperatorDesc> op = rop.getChildOperators().get(0);
            while (op instanceof ForwardOperator) {
                op = op.getChildOperators().get(0);
            }
            if (op instanceof GroupByOperator) {
                List<ColumnInfo> colInfos = rop.getSchema().getSignature();
                for (ExprNodeDesc expr : ((ReduceSinkDesc)rop.getConf()).getKeyCols()) {
                    lCtx.getIndex().putDependency(rop, colInfos.get(cnt++), ExprProcFactory.getExprDependency(lCtx, inpOp, expr, this.outputMap));
                }
                for (ExprNodeDesc expr : ((ReduceSinkDesc)rop.getConf()).getValueCols()) {
                    lCtx.getIndex().putDependency(rop, colInfos.get(cnt++), ExprProcFactory.getExprDependency(lCtx, inpOp, expr, this.outputMap));
                }
            } else {
                RowSchema schema = rop.getSchema();
                ReduceSinkDesc desc = (ReduceSinkDesc)rop.getConf();
                List<ExprNodeDesc> keyCols = desc.getKeyCols();
                List<String> keyColNames = desc.getOutputKeyColumnNames();
                for (int i = 0; i < keyCols.size(); ++i) {
                    ColumnInfo column = schema.getColumnInfo(String.valueOf((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(i));
                    if (column == null) continue;
                    lCtx.getIndex().putDependency(rop, column, ExprProcFactory.getExprDependency(lCtx, inpOp, keyCols.get(i), this.outputMap));
                }
                List<ExprNodeDesc> valCols = desc.getValueCols();
                List<String> valColNames = desc.getOutputValueColumnNames();
                for (int i = 0; i < valCols.size(); ++i) {
                    ColumnInfo column = schema.getColumnInfo(valColNames.get(i));
                    if (column == null) {
                        column = schema.getColumnInfo(String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + valColNames.get(i));
                    }
                    lCtx.getIndex().putDependency(rop, column, ExprProcFactory.getExprDependency(lCtx, inpOp, valCols.get(i), this.outputMap));
                }
            }
            return null;
        }
    }

    public static class DefaultLineage
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            Operator op = (Operator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            RowSchema rs = op.getSchema();
            List<ColumnInfo> inpCols = inpOp.getSchema().getSignature();
            int cnt = 0;
            for (ColumnInfo ci : rs.getSignature()) {
                lCtx.getIndex().putDependency(op, ci, lCtx.getIndex().getDependency(inpOp, inpCols.get(cnt++)));
            }
            return null;
        }
    }

    public static class FilterLineage
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (!stack.isEmpty());
            LineageCtx lCtx = (LineageCtx)procCtx;
            FilterOperator fop = (FilterOperator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, fop);
            FilterDesc filterDesc = (FilterDesc)fop.getConf();
            RowSchema rs = fop.getSchema();
            if (!filterDesc.isGenerated()) {
                LineageInfo.Predicate cond = new LineageInfo.Predicate();
                cond.setExpr(ExprProcFactory.getExprString(rs, filterDesc.getPredicate(), lCtx, inpOp, cond));
                lCtx.getIndex().addPredicate(fop, cond);
            }
            List<ColumnInfo> inpCols = inpOp.getSchema().getSignature();
            int cnt = 0;
            for (ColumnInfo ci : rs.getSignature()) {
                lCtx.getIndex().putDependency(fop, ci, lCtx.getIndex().getDependency(inpOp, inpCols.get(cnt++)));
            }
            return null;
        }
    }

    public static class PTFLineage
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LineageInfo.Dependency d;
            LineageCtx lCtx = (LineageCtx)procCtx;
            PTFOperator op = (PTFOperator)nd;
            Operator<? extends OperatorDesc> inpOp = OpProcFactory.getParent(stack);
            lCtx.getIndex().copyPredicates(inpOp, op);
            LineageInfo.Dependency dep = new LineageInfo.Dependency();
            LineageInfo.DependencyType newType = LineageInfo.DependencyType.EXPRESSION;
            dep.setType(newType);
            HashSet<String> columns = new HashSet<String>();
            PartitionedTableFunctionDef funcDef = ((PTFDesc)op.getConf()).getFuncDef();
            StringBuilder sb = new StringBuilder();
            WindowFrameDef windowFrameDef = null;
            if (!(funcDef.getTFunction() instanceof Noop)) {
                if (funcDef instanceof WindowTableFunctionDef) {
                    WindowFunctionDef windowFunctionDef = ((WindowTableFunctionDef)funcDef).getWindowFunctions().getFirst();
                    sb.append(windowFunctionDef.getName()).append("(");
                    this.addArgs(sb, columns, lCtx, inpOp, op.getSchema(), windowFunctionDef.getArgs());
                    windowFrameDef = windowFunctionDef.getWindowFrame();
                    if (sb.charAt(sb.length() - 2) == ',') {
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(")");
                    sb.append(" over (");
                } else {
                    sb.append(funcDef.getName()).append("(");
                    this.addArgs(sb, columns, lCtx, inpOp, funcDef.getRawInputShape().getRr().getRowSchema(), funcDef.getArgs());
                    if (funcDef.getInput() != null) {
                        sb.append("on ").append(funcDef.getInput().getAlias()).append(" ");
                        int counter = 1;
                        for (PTFExpressionDef pTFExpressionDef : funcDef.getArgs()) {
                            ExprNodeDesc exprNode = pTFExpressionDef.getExprNode();
                            this.addIfNotNull(columns, exprNode.getCols());
                            sb.append("arg").append(counter++).append("(");
                            sb.append(ExprProcFactory.getExprString(funcDef.getRawInputShape().getRr().getRowSchema(), pTFExpressionDef.getExprNode(), lCtx, inpOp, null));
                            sb.append("), ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                }
            }
            if (funcDef.getPartition() != null) {
                List<PTFExpressionDef> partitionExpressions = funcDef.getPartition().getExpressions();
                boolean isPartitionByAdded = false;
                for (PTFExpressionDef partitionExpr : partitionExpressions) {
                    ExprNodeDesc partitionExprNode = partitionExpr.getExprNode();
                    if (partitionExprNode.getCols() == null || partitionExprNode.getCols().isEmpty()) continue;
                    if (!isPartitionByAdded) {
                        sb.append("partition by ");
                        isPartitionByAdded = true;
                    }
                    this.addIfNotNull(columns, partitionExprNode.getCols());
                    if (partitionExprNode instanceof ExprNodeColumnDesc) {
                        sb.append(ExprProcFactory.getExprString(funcDef.getRawInputShape().getRr().getRowSchema(), partitionExprNode, lCtx, inpOp, null));
                        sb.append(", ");
                    }
                    sb.delete(sb.length() - 2, sb.length());
                }
            }
            if (funcDef.getOrder() != null) {
                List<OrderExpressionDef> orderExpressions = funcDef.getOrder().getExpressions();
                if (!sb.isEmpty() && sb.charAt(sb.length() - 1) != '(') {
                    sb.append(" ");
                }
                sb.append("order by ");
                for (OrderExpressionDef orderExpressionDef : orderExpressions) {
                    ExprNodeDesc orderExprNode = orderExpressionDef.getExprNode();
                    this.addIfNotNull(columns, orderExprNode.getCols());
                    sb.append(ExprProcFactory.getExprString(funcDef.getRawInputShape().getRr().getRowSchema(), orderExprNode, lCtx, inpOp, null));
                    if (PTFInvocationSpec.Order.DESC.equals((Object)orderExpressionDef.getOrder())) {
                        sb.append(" desc");
                    }
                    sb.append(", ");
                }
                sb.delete(sb.length() - 2, sb.length());
            }
            if (windowFrameDef != null) {
                sb.append(" ").append((Object)windowFrameDef.getWindowType()).append(" between ");
                PTFLineage.appendBoundary(windowFrameDef.getStart(), sb, " preceding");
                sb.append(" and ");
                PTFLineage.appendBoundary(windowFrameDef.getEnd(), sb, " following");
            }
            sb.append(")");
            dep.setExpr(sb.toString());
            LinkedHashSet<LineageInfo.BaseColumnInfo> colSet = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
            for (ColumnInfo columnInfo : inpOp.getSchema().getSignature()) {
                d = lCtx.getIndex().getDependency(inpOp, columnInfo);
                if (d == null) continue;
                newType = LineageCtx.getNewDependencyType(d.getType(), newType);
                if (columnInfo.isHiddenVirtualCol() || !columns.contains(columnInfo.getInternalName())) continue;
                colSet.addAll(d.getBaseCols());
            }
            dep.setType(newType);
            dep.setBaseCols(colSet);
            for (ColumnInfo columnInfo : op.getSchema().getSignature()) {
                d = dep;
                LineageInfo.Dependency depCi = lCtx.getIndex().getDependency(inpOp, columnInfo);
                if (depCi != null) {
                    d = depCi;
                }
                lCtx.getIndex().putDependency(op, columnInfo, d);
            }
            return null;
        }

        private static void appendBoundary(BoundaryDef boundary, StringBuilder sb, String boundaryText) {
            if (boundary.isCurrentRow()) {
                sb.append("current_row");
            } else {
                sb.append((String)(boundary.isUnbounded() ? "unbounded" : boundary.getAmt() + boundaryText));
            }
        }

        private void addArgs(StringBuilder sb, Set<String> columns, LineageCtx lCtx, Operator<? extends OperatorDesc> inpOp, RowSchema rowSchema, List<PTFExpressionDef> args) {
            if (args == null || args.isEmpty()) {
                return;
            }
            for (PTFExpressionDef arg : args) {
                ExprNodeDesc argNode = arg.getExprNode();
                if (argNode.getCols() != null && !argNode.getCols().isEmpty()) {
                    this.addIfNotNull(columns, argNode.getCols());
                }
                if (argNode instanceof ExprNodeConstantDesc) {
                    boolean isString = "string".equals(argNode.getTypeInfo().getTypeName());
                    if (isString) {
                        sb.append("'");
                    }
                    sb.append(((ExprNodeConstantDesc)argNode).getValue());
                    if (isString) {
                        sb.append("'");
                    }
                    sb.append(", ");
                    continue;
                }
                if (!(argNode instanceof ExprNodeColumnDesc) && !(argNode instanceof ExprNodeGenericFuncDesc)) continue;
                ExprNodeDesc exprNode = arg.getExprNode();
                this.addIfNotNull(columns, exprNode.getCols());
                sb.append(ExprProcFactory.getExprString(rowSchema, exprNode, lCtx, inpOp, null));
                sb.append(", ");
            }
        }

        private void addIfNotNull(Set<String> set, List<String> items) {
            if (items == null || items.isEmpty()) {
                return;
            }
            for (String item : items) {
                if (item == null) continue;
                set.add(item);
            }
        }
    }
}

