/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.cronutils.builder.CronBuilder;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.FieldExpressionFactory;
import com.google.common.base.Objects;
import java.util.ArrayList;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequestType;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.scheduled.ScheduledQueryMaintenanceWork;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.TimestampParser;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledQueryAnalyzer
extends BaseSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledQueryAnalyzer.class);

    public ScheduledQueryAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void initCtx(Context ctx) {
        ctx.setScheduledQuery(true);
        super.initCtx(ctx);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        ScheduledQuery schq;
        ScheduledQueryMaintenanceRequestType type = this.translateAstType(ast.getToken().getType());
        ScheduledQuery parsedSchq = this.interpretAstNode(ast);
        boolean throwException = true;
        if (type == ScheduledQueryMaintenanceRequestType.DROP) {
            boolean ifExists = ast.getFirstChildWithType(1054) != null;
            boolean bl = throwException = !ifExists && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DROP_IGNORES_NON_EXISTENT);
        }
        if ((schq = this.fillScheduledQuery(type, parsedSchq, throwException)) == null) {
            LOG.warn("Unable to find Scheduled query " + parsedSchq.getScheduleKey().getScheduleName());
            return;
        }
        this.checkAuthorization(type, schq);
        LOG.info("scheduled query operation: " + String.valueOf(type) + " " + String.valueOf(schq));
        try {
            schq.validate();
        }
        catch (TException e) {
            throw new SemanticException("ScheduledQuery is invalid", (Throwable)e);
        }
        ScheduledQueryMaintenanceWork work = new ScheduledQueryMaintenanceWork(type, schq);
        this.rootTasks.add(TaskFactory.get(work));
        this.queryState.setCommandType(this.toHiveOperation(type));
    }

    private ScheduledQuery fillScheduledQuery(ScheduledQueryMaintenanceRequestType type, ScheduledQuery schqChanges, boolean throwException) throws SemanticException {
        if (type == ScheduledQueryMaintenanceRequestType.CREATE) {
            return this.composeOverlayObject(schqChanges, this.buildEmptySchq());
        }
        try {
            ScheduledQuery schqStored = this.db.getMSC().getScheduledQuery(schqChanges.getScheduleKey());
            if (schqChanges.isSetUser()) {
                this.checkAuthorization(type, schqStored);
            }
            schqStored.setNextExecutionIsSet(false);
            return this.composeOverlayObject(schqChanges, schqStored);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                throw new SemanticException(ErrorMsg.INVALID_SCHEDULED_QUERY.format(schqChanges.getScheduleKey().getScheduleName()), (Throwable)e);
            }
            return null;
        }
        catch (TException e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
    }

    private ScheduledQuery buildEmptySchq() {
        ScheduledQuery ret = new ScheduledQuery();
        ret.setEnabled(this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_CREATE_AS_ENABLED));
        ret.setUser(this.getUserName());
        return ret;
    }

    private String getUserName() {
        SessionState sessionState = SessionState.get();
        if (sessionState.getAuthenticator() != null && sessionState.getAuthenticator().getUserName() != null) {
            return sessionState.getAuthenticator().getUserName();
        }
        String userName = sessionState.getUserName();
        if (userName == null) {
            throw new RuntimeException("userName is unset; this is unexpected");
        }
        return userName;
    }

    private ScheduledQuery composeOverlayObject(ScheduledQuery ... overlays) {
        ScheduledQuery._Fields[] q;
        ScheduledQuery ret = new ScheduledQuery();
        block0: for (ScheduledQuery._Fields field : q = ScheduledQuery._Fields.values()) {
            for (ScheduledQuery o : overlays) {
                if (!o.isSet(field)) continue;
                ret.setFieldValue(field, o.getFieldValue(field));
                continue block0;
            }
        }
        return ret;
    }

    private ScheduledQueryMaintenanceRequestType translateAstType(int type) throws SemanticException {
        switch (type) {
            case 967: {
                return ScheduledQueryMaintenanceRequestType.CREATE;
            }
            case 927: {
                return ScheduledQueryMaintenanceRequestType.ALTER;
            }
            case 1016: {
                return ScheduledQueryMaintenanceRequestType.DROP;
            }
        }
        throw new SemanticException("Can't handle: " + type);
    }

    private ScheduledQuery interpretAstNode(ASTNode ast) throws SemanticException {
        String scheduleName = ast.getChild(0).getText();
        String clusterNamespace = this.conf.getVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_NAMESPACE);
        LOG.info("scheduled query namespace:" + clusterNamespace);
        ScheduledQueryKey key = new ScheduledQueryKey(scheduleName, clusterNamespace);
        ScheduledQuery ret = new ScheduledQuery(key);
        for (int i = 1; i < ast.getChildCount(); ++i) {
            this.processScheduledQueryAstNode(ret, (ASTNode)ast.getChild(i));
        }
        return ret;
    }

    private void processScheduledQueryAstNode(ScheduledQuery schq, ASTNode node) throws SemanticException {
        switch (node.getType()) {
            case 1018: {
                schq.setEnabled(true);
                return;
            }
            case 1001: {
                schq.setEnabled(false);
                return;
            }
            case 969: {
                schq.setSchedule(ScheduledQueryAnalyzer.unescapeSQLString(node.getChild(0).getText()));
                return;
            }
            case 1194: {
                schq.setSchedule(this.interpretEveryNode(this.parseInteger(node.getChild(0).getChild(0), 1), node.getChild(1).getType(), this.parseTimeStamp(node.getChild(2))));
                return;
            }
            case 1023: {
                schq.setUser(ScheduledQueryAnalyzer.unescapeSQLString(node.getChild(0).getText()));
                return;
            }
            case 1161: {
                schq.setQuery(this.unparseTree(node.getChild(0)));
                return;
            }
            case 1022: {
                int now = (int)(System.currentTimeMillis() / 1000L);
                schq.setNextExecution(now);
                return;
            }
            case 1054: {
                return;
            }
        }
        throw new SemanticException("Unexpected token: " + node.getType());
    }

    private String interpretEveryNode(int every, int intervalToken, Timestamp ts) throws SemanticException {
        CronBuilder b = this.getDefaultCronBuilder();
        switch (intervalToken) {
            case 1064: {
                if (every != 1) {
                    throw new SemanticException("EVERY " + every + " DAY is not supported; only EVERY DAY is supported");
                }
                b.withSecond((FieldExpression)FieldExpressionFactory.on((int)ts.getSeconds()));
                b.withMinute((FieldExpression)FieldExpressionFactory.on((int)ts.getMinutes()));
                b.withHour((FieldExpression)FieldExpressionFactory.on((int)ts.getHours()));
                break;
            }
            case 1067: {
                b.withSecond((FieldExpression)FieldExpressionFactory.on((int)ts.getSeconds()));
                b.withMinute((FieldExpression)FieldExpressionFactory.on((int)ts.getMinutes()));
                b.withHour((FieldExpression)FieldExpressionFactory.every((FieldExpression)this.on0(ts.getHours()), (int)every));
                break;
            }
            case 1068: {
                b.withSecond((FieldExpression)FieldExpressionFactory.on((int)ts.getSeconds()));
                b.withMinute((FieldExpression)FieldExpressionFactory.every((FieldExpression)this.on0(ts.getMinutes()), (int)every));
                break;
            }
            case 1070: {
                b.withSecond((FieldExpression)FieldExpressionFactory.every((FieldExpression)this.on0(ts.getSeconds()), (int)every));
                break;
            }
            default: {
                throw new SemanticException("not supported schedule interval(only HOUR/MINUTE/SECOND is supported)");
            }
        }
        return b.instance().asString();
    }

    private FieldExpression on0(int n) {
        if (n == 0) {
            return FieldExpressionFactory.always();
        }
        return FieldExpressionFactory.on((int)n);
    }

    private int parseInteger(Tree node, int def) {
        if (node == null) {
            return def;
        }
        return Integer.parseInt(node.getText());
    }

    private Timestamp parseTimeStamp(Tree offsetNode) {
        if (offsetNode == null) {
            return new Timestamp();
        }
        ArrayList<String> s = new ArrayList<String>();
        s.add("iso8601");
        s.add("rfc1123");
        s.add("HH:mm:ss");
        s.add("H:mm:ss");
        s.add("HH:mm");
        TimestampParser p = new TimestampParser(s);
        return p.parseTimestamp(ScheduledQueryAnalyzer.unescapeSQLString(offsetNode.getText()));
    }

    private CronBuilder getDefaultCronBuilder() {
        CronDefinition definition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
        CronBuilder b = CronBuilder.cron((CronDefinition)definition).withYear((FieldExpression)FieldExpressionFactory.always()).withDoM((FieldExpression)FieldExpressionFactory.always()).withMonth((FieldExpression)FieldExpressionFactory.always()).withDoW((FieldExpression)FieldExpressionFactory.questionMark()).withHour((FieldExpression)FieldExpressionFactory.always()).withMinute((FieldExpression)FieldExpressionFactory.always()).withMinute((FieldExpression)FieldExpressionFactory.always()).withSecond((FieldExpression)FieldExpressionFactory.always());
        return b;
    }

    private void checkAuthorization(ScheduledQueryMaintenanceRequestType type, ScheduledQuery schq) throws SemanticException {
        boolean schqAuthorization = SessionState.get().getAuthorizerV2() != null && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SECURITY_AUTHORIZATION_SCHEDULED_QUERIES_SUPPORTED);
        try {
            if (!schqAuthorization) {
                String currentUser = this.getUserName();
                if (!Objects.equal((Object)currentUser, (Object)schq.getUser())) {
                    throw new HiveAccessControlException("Authorization of scheduled queries is not enabled - only owners may change scheduled queries (currentUser: " + currentUser + ", owner: " + schq.getUser() + ")");
                }
            } else {
                HiveOperationType opType = this.toHiveOpType(type);
                ArrayList<HivePrivilegeObject> privObjects = new ArrayList<HivePrivilegeObject>();
                ScheduledQueryKey key = schq.getScheduleKey();
                privObjects.add(HivePrivilegeObject.forScheduledQuery(schq.getUser(), key.getClusterNamespace(), key.getScheduleName()));
                SessionState.get().getAuthorizerV2().checkPrivileges(opType, privObjects, privObjects, new HiveAuthzContext.Builder().build());
            }
        }
        catch (Exception e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
    }

    private HiveOperationType toHiveOpType(ScheduledQueryMaintenanceRequestType type) throws SemanticException {
        switch (type) {
            case CREATE: {
                return HiveOperationType.CREATE_SCHEDULED_QUERY;
            }
            case ALTER: {
                return HiveOperationType.ALTER_SCHEDULED_QUERY;
            }
            case DROP: {
                return HiveOperationType.DROP_SCHEDULED_QUERY;
            }
        }
        throw new SemanticException("Unexpected type: " + String.valueOf(type));
    }

    private HiveOperation toHiveOperation(ScheduledQueryMaintenanceRequestType type) throws SemanticException {
        switch (type) {
            case CREATE: {
                return HiveOperation.CREATE_SCHEDULED_QUERY;
            }
            case ALTER: {
                return HiveOperation.ALTER_SCHEDULED_QUERY;
            }
            case DROP: {
                return HiveOperation.DROP_SCHEDULED_QUERY;
            }
        }
        throw new SemanticException("Unexpected type: " + String.valueOf(type));
    }

    private String unparseTree(Tree child) throws SemanticException {
        ASTNode input = (ASTNode)child;
        ((HiveConf)this.ctx.getConf()).setBoolVar(HiveConf.ConfVars.HIVE_CBO_ENABLED, false);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.queryState, input);
        sem.analyze(input, this.ctx);
        sem.validate();
        sem.executeUnParseTranslations();
        String expandedText = this.ctx.getTokenRewriteStream().toString(input.getTokenStartIndex(), input.getTokenStopIndex());
        return expandedText;
    }
}

