/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.antlr.runtime.TokenRewriteStream;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;

public class SubQueryDiagnostic {
    static QBSubQueryRewrite getRewrite(QBSubQuery subQuery, TokenRewriteStream stream, Context ctx) {
        if (ctx.isExplainSkipExecution()) {
            return new QBSubQueryRewrite(subQuery, stream);
        }
        return new QBSubQueryRewriteNoop(subQuery, stream);
    }

    public static class QBSubQueryRewrite {
        QBSubQuery subQuery;
        TokenRewriteStream stream;
        String whereClause;
        String selectClauseAdditions;
        String gByClauseAdditions;
        boolean addGroupByClause;
        String joiningCondition;
        String outerQueryPostJoinCond;

        QBSubQueryRewrite(QBSubQuery subQuery, TokenRewriteStream stream) {
            this.subQuery = subQuery;
            this.stream = stream;
        }

        public String getRewrittenQuery() {
            ASTNode sqAST = this.subQuery.getSubQueryAST();
            if (this.whereClause != null) {
                ASTNode whereAST = (ASTNode)sqAST.getChild(1).getChild(2);
                this.stream.replace(this.subQuery.getAlias(), whereAST.getTokenStartIndex(), whereAST.getTokenStopIndex(), (Object)this.whereClause);
            }
            if (this.selectClauseAdditions != null) {
                ASTNode selectClause = (ASTNode)sqAST.getChild(1).getChild(1);
                this.stream.insertAfter(this.subQuery.getAlias(), selectClause.getTokenStopIndex(), (Object)this.selectClauseAdditions);
            }
            if (this.gByClauseAdditions != null) {
                if (!this.addGroupByClause) {
                    ASTNode groupBy = (ASTNode)sqAST.getChild(1).getChild(3);
                    this.stream.insertAfter(this.subQuery.getAlias(), groupBy.getTokenStopIndex(), (Object)this.gByClauseAdditions);
                } else {
                    this.gByClauseAdditions = " group by " + this.gByClauseAdditions;
                    this.stream.insertAfter(this.subQuery.getAlias(), sqAST.getTokenStopIndex() - 1, (Object)this.gByClauseAdditions);
                }
            }
            try {
                String string = this.stream.toString(this.subQuery.getAlias(), sqAST.getTokenStartIndex(), sqAST.getTokenStopIndex()) + " " + this.subQuery.getAlias();
                return string;
            }
            finally {
                this.stream.deleteProgram(this.subQuery.getAlias());
            }
        }

        public String getJoiningCondition() {
            return this.joiningCondition;
        }

        void addWhereClauseRewrite(ASTNode predicate) {
            String cond = this.stream.toString(predicate.getTokenStartIndex(), predicate.getTokenStopIndex());
            this.addWhereClauseRewrite(cond);
        }

        void addWhereClauseRewrite(String cond) {
            this.whereClause = this.whereClause == null ? "where " : this.whereClause + " and ";
            this.whereClause = this.whereClause + cond;
        }

        void addSelectClauseRewrite(ASTNode selectExpr, String alias) {
            if (this.selectClauseAdditions == null) {
                this.selectClauseAdditions = "";
            }
            this.selectClauseAdditions = this.selectClauseAdditions + ", " + this.stream.toString(selectExpr.getTokenStartIndex(), selectExpr.getTokenStopIndex()) + " as " + alias;
        }

        void setAddGroupByClause() {
            this.addGroupByClause = true;
        }

        void addGByClauseRewrite(ASTNode selectExpr) {
            if (this.gByClauseAdditions == null) {
                this.gByClauseAdditions = "";
            }
            if (!this.addGroupByClause || !this.gByClauseAdditions.equals("")) {
                this.gByClauseAdditions = this.gByClauseAdditions + ", ";
            }
            this.gByClauseAdditions = this.gByClauseAdditions + this.stream.toString(selectExpr.getTokenStartIndex(), selectExpr.getTokenStopIndex());
        }

        void addJoinCondition(ASTNode joinCond, boolean leftIsRewritten, boolean rightIsRewritten) {
            StringBuilder b = new StringBuilder();
            if (this.joiningCondition == null) {
                this.joiningCondition = " on ";
            } else {
                b.append(" and ");
            }
            this.addCondition(b, (ASTNode)joinCond.getChild(0), leftIsRewritten);
            b.append(" = ");
            this.addCondition(b, (ASTNode)joinCond.getChild(1), rightIsRewritten);
            this.joiningCondition = this.joiningCondition + b.toString();
        }

        private void addCondition(StringBuilder b, ASTNode cond, boolean rewritten) {
            if (!rewritten) {
                b.append(this.stream.toString(cond.getTokenStartIndex(), cond.getTokenStopIndex()));
            } else {
                this.addReference(b, cond);
            }
        }

        private void addReference(StringBuilder b, ASTNode ref) {
            if (ref.getType() == 16) {
                b.append(ref.getChild(0).getChild(0).getText()).append(".").append(ref.getChild(1).getText());
            } else {
                b.append(ref.getText());
            }
        }

        void addPostJoinCondition(ASTNode cond) {
            StringBuilder b = new StringBuilder();
            this.addReference(b, (ASTNode)cond.getChild(1));
            this.outerQueryPostJoinCond = b.toString() + " is null";
        }

        public String getOuterQueryPostJoinCond() {
            return this.outerQueryPostJoinCond;
        }
    }

    public static class QBSubQueryRewriteNoop
    extends QBSubQueryRewrite {
        QBSubQueryRewriteNoop(QBSubQuery subQuery, TokenRewriteStream stream) {
            super(subQuery, stream);
        }

        @Override
        public final String getRewrittenQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final String getJoiningCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        final void addWhereClauseRewrite(ASTNode predicate) {
        }

        @Override
        final void addWhereClauseRewrite(String cond) {
        }

        @Override
        final void addSelectClauseRewrite(ASTNode selectExpr, String alias) {
        }

        @Override
        final void setAddGroupByClause() {
        }

        @Override
        final void addGByClauseRewrite(ASTNode selectExpr) {
        }

        @Override
        final void addJoinCondition(ASTNode joinCond, boolean leftIsRewritten, boolean rightIsRewritten) {
        }

        @Override
        final void addPostJoinCondition(ASTNode cond) {
        }

        @Override
        public final String getOuterQueryPostJoinCond() {
            throw new UnsupportedOperationException();
        }
    }
}

