/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.GetAllWriteEventInfoRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.metadata.HiveFatalException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class CommitTxnHandler
extends AbstractEventHandler<CommitTxnMessage> {
    CommitTxnHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    CommitTxnMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getCommitTxnMessage(stringRepresentation);
    }

    private void writeDumpFiles(Table qlMdTable, Partition ptn, Iterable<String> files, EventHandler.Context withinContext, Path dataPath) throws IOException, HiveFatalException, SemanticException {
        boolean copyAtLoad = withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        if (copyAtLoad) {
            this.writeEncodedDumpFiles(withinContext, files, dataPath);
        } else {
            for (String file : files) {
                this.writeFileEntry(qlMdTable, ptn, file, withinContext);
            }
        }
    }

    private void createDumpFile(EventHandler.Context withinContext, Table qlMdTable, List<Partition> qlPtns, List<List<String>> fileListArray) throws IOException, SemanticException, HiveFatalException {
        if (fileListArray == null || fileListArray.isEmpty()) {
            return;
        }
        Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
        withinContext.replicationSpec.setIsReplace(false);
        EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, qlPtns, withinContext.replicationSpec, withinContext.hiveConf);
        if (null == qlPtns || qlPtns.isEmpty()) {
            Path dataPath = new Path(withinContext.eventRoot, "data");
            this.writeDumpFiles(qlMdTable, null, (Iterable<String>)fileListArray.getFirst(), withinContext, dataPath);
        } else {
            for (int idx = 0; idx < qlPtns.size(); ++idx) {
                Path dataPath = new Path(withinContext.eventRoot, "data" + File.separator + qlPtns.get(idx).getName());
                this.writeDumpFiles(qlMdTable, qlPtns.get(idx), (Iterable<String>)fileListArray.get(idx), withinContext, dataPath);
            }
        }
    }

    private void createDumpFileForTable(EventHandler.Context withinContext, Table qlMdTable, List<Partition> qlPtns, List<List<String>> fileListArray) throws IOException, SemanticException, HiveFatalException {
        Path newPath = HiveUtils.getDumpPath(withinContext.eventRoot, qlMdTable.getDbName(), qlMdTable.getTableName());
        EventHandler.Context context = new EventHandler.Context(withinContext);
        context.setEventRoot(newPath);
        this.createDumpFile(context, qlMdTable, qlPtns, fileListArray);
    }

    private List<WriteEventInfo> getAllWriteEventInfo(EventHandler.Context withinContext) throws Exception {
        String contextDbName = StringUtils.normalizeIdentifier((String)withinContext.replScope.getDbName());
        GetAllWriteEventInfoRequest request = new GetAllWriteEventInfoRequest(((CommitTxnMessage)this.eventMessage).getTxnId().longValue());
        request.setDbName(contextDbName);
        List writeEventInfoList = withinContext.db.getMSC().getAllWriteEventInfo(request);
        return writeEventInfoList == null ? null : new ArrayList(Collections2.filter((Collection)writeEventInfoList, writeEventInfo -> {
            assert (writeEventInfo != null);
            return ReplUtils.tableIncludedInReplScope(withinContext.replScope, writeEventInfo.getTable()) && ReplUtils.tableIncludedInReplScope(withinContext.oldReplScope, writeEventInfo.getTable()) && !withinContext.getTablesForBootstrap().contains(writeEventInfo.getTable().toLowerCase());
        }));
    }

    private List<WriteEventInfo> getAllWriteEventInfoExceptMV(List<WriteEventInfo> writeEventInfoList) {
        return writeEventInfoList.stream().filter(writeEventInfo -> {
            try {
                if (writeEventInfo.getTableObj() != null) {
                    Table table = new Table((org.apache.hadoop.hive.metastore.api.Table)MessageBuilder.getTObj((String)writeEventInfo.getTableObj(), org.apache.hadoop.hive.metastore.api.Table.class));
                    return !table.isMaterializedView();
                }
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        if (!ReplUtils.includeAcidTableInDump(withinContext.hiveConf)) {
            return;
        }
        LOG.info("Processing#{} COMMIT_TXN message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        String payload = this.eventMessageAsJSON;
        if (!withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY)) {
            int numEntry;
            boolean replicatingAcidEvents = true;
            if (withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES)) {
                LOG.debug("writeEventsInfoList will be removed from commit message because we are bootstrapping acid tables.");
                replicatingAcidEvents = false;
            } else if (!ReplUtils.includeAcidTableInDump(withinContext.hiveConf)) {
                LOG.debug("writeEventsInfoList will be removed from commit message because we are not dumping acid tables.");
                replicatingAcidEvents = false;
            }
            List<WriteEventInfo> writeEventInfoList = null;
            List<WriteEventInfo> allWriteEventInfoExceptMV = null;
            if (replicatingAcidEvents) {
                writeEventInfoList = this.getAllWriteEventInfo(withinContext);
                if (writeEventInfoList != null) {
                    allWriteEventInfoExceptMV = this.getAllWriteEventInfoExceptMV(writeEventInfoList);
                }
                String dbName = StringUtils.normalizeIdentifier((String)withinContext.replScope.getDbName());
                if (ReplUtils.filterTransactionOperations(withinContext.hiveConf)) {
                    boolean shouldSkip;
                    List writeIds = ((CommitTxnMessage)this.eventMessage).getWriteIds();
                    List<String> databases = Optional.ofNullable(((CommitTxnMessage)this.eventMessage).getDatabases()).orElse(Collections.emptyList()).stream().map(StringUtils::normalizeIdentifier).toList();
                    boolean bl = shouldSkip = writeIds == null || writeIds.isEmpty() || !databases.contains(dbName);
                    if (writeEventInfoList != null && !writeEventInfoList.isEmpty()) {
                        boolean bl2 = shouldSkip = writeEventInfoList.size() != allWriteEventInfoExceptMV.size();
                    }
                    if (shouldSkip) {
                        LOG.debug("skipping commit txn event for db: {}, writeIds: {}, writeEventInfoList: {}, databases: {}", new Object[]{dbName, writeIds, writeEventInfoList, databases});
                        return;
                    }
                }
            }
            if (writeEventInfoList != null) {
                writeEventInfoList = allWriteEventInfoExceptMV;
            }
            int n = numEntry = writeEventInfoList != null ? writeEventInfoList.size() : 0;
            if (numEntry != 0) {
                ((CommitTxnMessage)this.eventMessage).addWriteEventInfo(writeEventInfoList);
                payload = jsonMessageEncoder.getSerializer().serialize(this.eventMessage);
                LOG.debug("payload for commit txn event : {}", (Object)this.eventMessageAsJSON);
            }
            Table qlMdTablePrev = null;
            ArrayList<Partition> qlPtns = new ArrayList<Partition>();
            ArrayList<List<String>> filesTobeAdded = new ArrayList<List<String>>();
            for (int idx = 0; idx < numEntry; ++idx) {
                Table qlMdTable = new Table(((CommitTxnMessage)this.eventMessage).getTableObj(idx));
                if (qlMdTablePrev == null) {
                    qlMdTablePrev = qlMdTable;
                }
                if (!qlMdTablePrev.getCompleteName().equals(qlMdTable.getCompleteName())) {
                    this.createDumpFileForTable(withinContext, qlMdTablePrev, qlPtns, filesTobeAdded);
                    qlPtns = new ArrayList();
                    filesTobeAdded = new ArrayList();
                    qlMdTablePrev = qlMdTable;
                }
                if (qlMdTable.isPartitioned() && null != ((CommitTxnMessage)this.eventMessage).getPartitionObj(idx)) {
                    qlPtns.add(new Partition(qlMdTable, ((CommitTxnMessage)this.eventMessage).getPartitionObj(idx)));
                }
                filesTobeAdded.add(Lists.newArrayList((Object[])ReplChangeManager.getListFromSeparatedString((String)((CommitTxnMessage)this.eventMessage).getFiles(idx))));
            }
            if (qlMdTablePrev != null) {
                this.createDumpFileForTable(withinContext, qlMdTablePrev, qlPtns, filesTobeAdded);
            }
        }
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(payload);
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_COMMIT_TXN;
    }
}

