/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.create.CreateFunctionDesc;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.PathBuilder;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.util.Time;

public class CreateFunctionHandler
extends AbstractMessageHandler {
    private String functionName;

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        try {
            FunctionDescBuilder builder = new FunctionDescBuilder(context);
            CreateFunctionDesc descToLoad = builder.build();
            this.functionName = builder.metadata.function.getFunctionName();
            context.log.debug("Loading function desc : {}", (Object)descToLoad.toString());
            Task<DDLWork> createTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, descToLoad, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
            context.log.debug("Added create function task : {}:{},{}", new Object[]{createTask.getId(), descToLoad.getName(), descToLoad.getClassName()});
            if (context.dmd != null) {
                this.updatedMetadata.set(context.dmd.getEventTo().toString(), builder.destinationDbName, null, null);
            }
            this.readEntitySet.add(BaseSemanticAnalyzer.toReadEntity(new Path(context.location), context.hiveConf));
            if (builder.replCopyTasks.isEmpty()) {
                return Collections.singletonList(createTask);
            }
            Task<DependencyCollectionWork> barrierTask = TaskFactory.get(new DependencyCollectionWork(), context.hiveConf);
            builder.replCopyTasks.forEach(t -> t.addDependentTask(barrierTask));
            barrierTask.addDependentTask(createTask);
            return builder.replCopyTasks;
        }
        catch (Exception e) {
            throw e instanceof SemanticException ? (SemanticException)((Object)e) : new SemanticException("Error reading message members", (Throwable)e);
        }
    }

    private static class FunctionDescBuilder {
        private final MessageHandler.Context context;
        private final MetaData metadata;
        private final String destinationDbName;
        private final List<Task<?>> replCopyTasks = new ArrayList();

        private FunctionDescBuilder(MessageHandler.Context context) throws SemanticException {
            this.context = context;
            try {
                FileSystem fs = FileSystem.get((URI)new Path(context.location).toUri(), (Configuration)context.hiveConf);
                this.metadata = EximUtil.readMetaData(fs, new Path(context.location, "_metadata"));
            }
            catch (IOException e) {
                throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), (Throwable)e);
            }
            this.destinationDbName = context.isDbNameEmpty() ? this.metadata.function.getDbName() : context.dbName;
        }

        private CreateFunctionDesc build() throws SemanticException {
            this.replCopyTasks.clear();
            PrimaryToReplicaResourceFunction conversionFunction = new PrimaryToReplicaResourceFunction(this.context, this.metadata, this.destinationDbName);
            ImmutableList transformedUris = this.metadata.function.getResourceUris() == null ? null : ImmutableList.copyOf((Collection)Lists.transform((List)this.metadata.function.getResourceUris(), (Function)conversionFunction));
            this.replCopyTasks.addAll(conversionFunction.replCopyTasks);
            String fullQualifiedFunctionName = FunctionUtils.qualifyFunctionName(this.metadata.function.getFunctionName(), this.destinationDbName);
            ReplicationSpec replSpec = this.context.dmd == null ? null : this.context.eventOnlyReplicationSpec();
            return new CreateFunctionDesc(fullQualifiedFunctionName, this.metadata.function.getClassName(), false, (List<ResourceUri>)transformedUris, replSpec);
        }
    }

    static class PrimaryToReplicaResourceFunction
    implements Function<ResourceUri, ResourceUri> {
        private final MessageHandler.Context context;
        private final MetaData metadata;
        private final List<Task<?>> replCopyTasks = new ArrayList();
        private final String functionsRootDir;
        private String destinationDbName;

        PrimaryToReplicaResourceFunction(MessageHandler.Context context, MetaData metadata, String destinationDbName) {
            this.context = context;
            this.metadata = metadata;
            this.destinationDbName = destinationDbName;
            this.functionsRootDir = context.hiveConf.getVar(HiveConf.ConfVars.REPL_FUNCTIONS_ROOT_DIR);
        }

        public ResourceUri apply(ResourceUri resourceUri) {
            try {
                return resourceUri.getUri().toLowerCase().startsWith("hdfs:") ? this.destinationResourceUri(resourceUri) : resourceUri;
            }
            catch (IOException | SemanticException e) {
                throw new RuntimeException(e);
            }
        }

        ResourceUri destinationResourceUri(ResourceUri resourceUri) throws IOException, SemanticException {
            String sourceUri = resourceUri.getUri();
            String[] split = ReplChangeManager.decodeFileUri((String)sourceUri)[0].split("/");
            PathBuilder pathBuilder = new PathBuilder(this.functionsRootDir);
            Path qualifiedDestinationPath = PathBuilder.fullyQualifiedHDFSUri(pathBuilder.addDescendant(this.destinationDbName.toLowerCase()).addDescendant(this.metadata.function.getFunctionName().toLowerCase()).addDescendant(String.valueOf(Time.monotonicNowNanos())).addDescendant(split[split.length - 1]).build(), new Path(this.functionsRootDir).getFileSystem((Configuration)this.context.hiveConf));
            this.replCopyTasks.add(this.getCopyTask(sourceUri, qualifiedDestinationPath));
            ResourceUri destinationUri = new ResourceUri(resourceUri.getResourceType(), qualifiedDestinationPath.toString());
            this.context.log.debug("copy source uri : {} to destination uri: {}", (Object)sourceUri, (Object)destinationUri);
            return destinationUri;
        }

        private Task<?> getCopyTask(String sourceUri, Path dest) {
            boolean copyAtLoad = this.context.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
            if (copyAtLoad) {
                return ReplCopyTask.getLoadCopyTask(this.metadata.getReplicationSpec(), new Path(sourceUri), dest, this.context.hiveConf, this.context.getDumpDirectory(), this.context.getMetricCollector());
            }
            return TaskFactory.get(new CopyWork(new Path(sourceUri), dest.getParent(), true, false, this.context.getDumpDirectory(), this.context.getMetricCollector(), true), this.context.hiveConf);
        }
    }
}

