/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite.sql;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;

public abstract class MultiInsertSqlGenerator {
    private static final String INDENT = "  ";
    protected final Table targetTable;
    protected final String targetTableFullName;
    protected final HiveConf conf;
    protected final String subQueryAlias;
    protected StringBuilder queryStr;
    private Deque<StringBuilder> stack = new ArrayDeque<StringBuilder>();
    private int nextCteExprPos = 0;

    protected MultiInsertSqlGenerator(Table targetTable, String targetTableFullName, HiveConf conf, String subQueryAlias) {
        this.targetTable = targetTable;
        this.targetTableFullName = targetTableFullName;
        this.conf = conf;
        this.subQueryAlias = subQueryAlias;
        this.queryStr = new StringBuilder();
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public String getTargetTableFullName() {
        return this.targetTableFullName;
    }

    public abstract void appendAcidSelectColumns(Context.Operation var1);

    public void appendAcidSelectColumnsForDeletedRecords(Context.Operation operation, boolean skipPrefix) {
        throw new UnsupportedOperationException();
    }

    public abstract List<String> getDeleteValues(Context.Operation var1);

    public abstract List<String> getSortKeys(Context.Operation var1);

    public String qualify(String columnName) {
        if (StringUtils.isBlank((CharSequence)this.subQueryAlias)) {
            return columnName;
        }
        return String.format("%s.%s", this.subQueryAlias, columnName);
    }

    public void appendInsertBranch(String hintStr, List<String> values) {
        this.queryStr.append("INSERT INTO ").append(this.targetTableFullName);
        this.appendPartitionCols(this.targetTable);
        this.queryStr.append("\n");
        this.queryStr.append(INDENT);
        this.queryStr.append("SELECT ");
        if (StringUtils.isNotBlank((CharSequence)hintStr)) {
            this.queryStr.append(hintStr);
        }
        this.queryStr.append(StringUtils.join(values, (String)","));
        this.queryStr.append("\n");
    }

    public void appendDeleteBranch(String hintStr) {
        List<String> deleteValues = this.getDeleteValues(Context.Operation.DELETE);
        this.appendInsertBranch(hintStr, deleteValues);
    }

    public void appendPartitionColsOfTarget() {
        this.appendPartitionCols(this.targetTable);
    }

    public void appendPartitionCols(Table table) {
        List<FieldSchema> partCols = table.getPartCols();
        if (partCols == null || partCols.isEmpty()) {
            return;
        }
        this.queryStr.append(" partition (");
        this.appendCols(partCols, FieldSchema::getName);
        this.queryStr.append(")");
    }

    private void appendSortBy(List<String> keys) {
        if (keys.isEmpty()) {
            return;
        }
        this.queryStr.append(INDENT).append("SORT BY ");
        this.queryStr.append(StringUtils.join(keys, (String)","));
        this.queryStr.append("\n");
    }

    public void appendSortKeys() {
        this.appendSortBy(this.getSortKeys(Context.Operation.DELETE));
    }

    public MultiInsertSqlGenerator append(String sqlTextFragment) {
        this.queryStr.append(sqlTextFragment);
        return this;
    }

    public String toString() {
        return this.queryStr.toString();
    }

    public void removeLastChar() {
        this.queryStr.setLength(this.queryStr.length() - 1);
    }

    public void appendPartColsOfTargetTableWithComma(String alias) {
        if (this.targetTable.getPartCols() == null || this.targetTable.getPartCols().isEmpty()) {
            return;
        }
        this.queryStr.append(',');
        this.appendCols(this.targetTable.getPartCols(), alias, null, FieldSchema::getName);
    }

    public void appendAllColsOfTargetTable(String prefix) {
        this.appendCols(this.targetTable.getAllCols(), null, prefix, FieldSchema::getName);
    }

    public void appendAllColsOfTargetTable() {
        this.appendCols(this.targetTable.getAllCols(), FieldSchema::getName);
    }

    public <T> void appendCols(List<T> columns, Function<T, String> stringConverter) {
        this.appendCols(columns, null, null, stringConverter);
    }

    public <T> void appendCols(List<T> columns, String alias, String prefix, Function<T, String> stringConverter) {
        if (columns == null) {
            return;
        }
        String quotedAlias = null;
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            quotedAlias = HiveUtils.unparseIdentifier(alias, (Configuration)this.conf);
        }
        boolean first = true;
        for (T fschema : columns) {
            if (first) {
                first = false;
            } else {
                this.queryStr.append(", ");
            }
            if (quotedAlias != null) {
                this.queryStr.append(quotedAlias).append('.');
            }
            this.queryStr.append(HiveUtils.unparseIdentifier(stringConverter.apply(fschema), (Configuration)this.conf));
            if (!StringUtils.isNotBlank((CharSequence)prefix)) continue;
            this.queryStr.append(" AS ");
            String prefixedIdentifier = HiveUtils.unparseIdentifier(prefix + stringConverter.apply(fschema), (Configuration)this.conf);
            this.queryStr.append(prefixedIdentifier);
        }
    }

    public MultiInsertSqlGenerator appendTargetTableName() {
        this.queryStr.append(this.targetTableFullName);
        return this;
    }

    public MultiInsertSqlGenerator append(char c) {
        this.queryStr.append(c);
        return this;
    }

    public MultiInsertSqlGenerator indent() {
        this.queryStr.append(INDENT);
        return this;
    }

    public MultiInsertSqlGenerator appendSubQueryAlias() {
        this.queryStr.append(this.subQueryAlias);
        return this;
    }

    public MultiInsertSqlGenerator newCteExpr() {
        this.stack.push(this.queryStr);
        this.queryStr = new StringBuilder(this.nextCteExprPos > 0 ? ",\n" : "WITH ");
        return this;
    }

    public MultiInsertSqlGenerator addCteExpr() {
        this.queryStr = this.stack.pop().insert(this.nextCteExprPos, this.queryStr);
        this.nextCteExprPos = this.queryStr.length();
        return this;
    }
}

