/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;

public class NativeAcidMultiInsertSqlGenerator
extends MultiInsertSqlGenerator {
    public NativeAcidMultiInsertSqlGenerator(Table table, String targetTableFullName, HiveConf conf, String subQueryAlias) {
        super(table, targetTableFullName, conf, subQueryAlias);
    }

    @Override
    public void appendAcidSelectColumns(Context.Operation operation) {
        this.queryStr.append("ROW__ID,");
        for (FieldSchema fieldSchema : this.targetTable.getPartCols()) {
            String identifier = HiveUtils.unparseIdentifier(fieldSchema.getName(), (Configuration)this.conf);
            this.queryStr.append(identifier);
            this.queryStr.append(",");
        }
    }

    @Override
    public List<String> getDeleteValues(Context.Operation operation) {
        ArrayList<String> deleteValues = new ArrayList<String>(1 + this.targetTable.getPartCols().size());
        deleteValues.add(this.qualify("ROW__ID"));
        for (FieldSchema fieldSchema : this.targetTable.getPartCols()) {
            deleteValues.add(this.qualify(HiveUtils.unparseIdentifier(fieldSchema.getName(), (Configuration)this.conf)));
        }
        return deleteValues;
    }

    @Override
    public List<String> getSortKeys(Context.Operation operation) {
        return Collections.singletonList(this.qualify("ROW__ID"));
    }
}

