/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.io.DataOutputBuffer;

@Explain(displayName="Dynamic Partitioning Event Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DynamicPruningEventDesc
extends AppMasterEventDesc {
    private String targetColumnName;
    private String targetColumnType;
    private transient TableScanOperator tableScan;
    private transient ReduceSinkOperator generator;
    private ExprNodeDesc partKey;
    private ExprNodeDesc predicate;

    public ExprNodeDesc getPredicate() {
        return this.predicate;
    }

    public void setPredicate(ExprNodeDesc predicate) {
        this.predicate = predicate;
    }

    public String getPartPredicateString() {
        return this.predicate != null ? this.predicate.getExprString() : "-";
    }

    public TableScanOperator getTableScan() {
        return this.tableScan;
    }

    public void setTableScan(TableScanOperator tableScan) {
        this.tableScan = tableScan;
    }

    public ReduceSinkOperator getGenerator() {
        return this.generator;
    }

    public void setGenerator(ReduceSinkOperator generator) {
        this.generator = generator;
    }

    @Explain(displayName="Target column")
    public String displayTargetColumn() {
        return this.targetColumnName + " (" + this.targetColumnType + ")";
    }

    @Signature
    public String getTargetColumnName() {
        return this.targetColumnName;
    }

    public void setTargetColumnName(String columnName) {
        this.targetColumnName = columnName;
    }

    @Signature
    public String getTargetColumnType() {
        return this.targetColumnType;
    }

    public void setTargetColumnType(String columnType) {
        this.targetColumnType = columnType;
    }

    @Override
    public void writeEventHeader(DataOutputBuffer buffer) throws IOException {
        super.writeEventHeader(buffer);
        buffer.writeUTF(this.targetColumnName);
    }

    public void setPartKey(ExprNodeDesc partKey) {
        this.partKey = partKey;
    }

    @Explain(displayName="Partition key expr")
    @Signature
    public String getPartKeyString() {
        return this.partKey.getExprString();
    }

    public ExprNodeDesc getPartKey() {
        return this.partKey;
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (super.isSame(other)) {
            DynamicPruningEventDesc otherDesc = (DynamicPruningEventDesc)other;
            return Objects.equals(this.getTargetColumnName(), otherDesc.getTargetColumnName()) && Objects.equals(this.getTargetColumnType(), otherDesc.getTargetColumnType()) && Objects.equals(this.getPartKeyString(), otherDesc.getPartKeyString()) && Objects.equals(this.getPartPredicateString(), otherDesc.getPartPredicateString());
        }
        return false;
    }
}

