/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.queryhistory;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ServiceContext;
import org.apache.hadoop.hive.ql.exec.tez.TezRuntimeContext;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.queryhistory.schema.Record;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.TaskCounter;

public class RecordEnricher {
    private final DriverContext driverContext;
    private final ServiceContext serviceContext;
    private final SessionState sessionState;
    private final PerfLogger perfLogger;

    public RecordEnricher(DriverContext driverContext, ServiceContext serviceContext, SessionState sessionState, PerfLogger perfLogger) {
        this.driverContext = driverContext;
        this.serviceContext = serviceContext;
        this.sessionState = sessionState;
        this.perfLogger = perfLogger;
    }

    public Record createRecord() {
        Record record = new Record();
        this.enrichFromDriverContext(record);
        this.enrichFromSessionState(record);
        this.enrichFromPerfLogger(record);
        this.enrichFromServiceContext(record);
        return record;
    }

    private void enrichFromDriverContext(Record record) {
        this.enrichFromQueryState(this.driverContext.getQueryState(), record);
        this.enrichFromQueryInfo(this.driverContext.getQueryInfo(), record);
        this.enrichFromRuntimeContext(this.driverContext.getRuntimeContext(), record);
        this.enrichFromQueryProperties(this.driverContext.getQueryProperties(), record);
        record.setPlan(this.driverContext.getExplainPlan());
        record.setQueryType(this.driverContext.getQueryType());
        record.setOperation(this.getClassifiedOperation());
        record.setFailureReason(this.driverContext.getQueryErrorMessage());
        record.setNumRowsFetched(this.driverContext.getFetchTask() == null ? 0 : this.driverContext.getFetchTask().getNumRows());
    }

    private String getClassifiedOperation() {
        QueryState queryState = this.driverContext.getQueryState();
        return queryState.getSqlKind() == null ? queryState.getCommandType() : queryState.getSqlKind().toString();
    }

    private void enrichFromSessionState(Record record) {
        record.setSessionId(this.sessionState.getSessionId());
        record.setEndUser(this.sessionState.getUserName());
        record.setClientProtocol(this.sessionState.getConf().getInt("list.sink.output.protocol", 0));
        try {
            boolean doAsEnabled = this.sessionState.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
            String user = Utils.getUGI().getShortUserName();
            record.setClusterUser(doAsEnabled ? this.sessionState.getUserName() : user);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        record.setSessionType(this.sessionState.isHiveServerQuery() ? SessionType.HIVESERVER2.name() : SessionType.OTHER.name());
        record.setCurrentDatabase(this.sessionState.getCurrentDatabase());
        record.setClientAddress(this.sessionState.getUserIpAddress());
        record.setConfigurationOptionsChanged(this.sessionState.getOverriddenConfigurations());
    }

    private void enrichFromPerfLogger(Record record) {
        record.setPlanningDuration(this.perfLogger.getEndTime("compile") - this.perfLogger.getStartTime("compile"));
        record.setPlanningStartTime(this.perfLogger.getStartTime("compile"));
        record.setPreparePlanDuration(this.perfLogger.getPreparePlanDuration());
        record.setPreparePlanStartTime(this.perfLogger.getEndTime("compile"));
        record.setGetSessionDuration(this.perfLogger.getDuration("TezGetSession"));
        record.setGetSessionStartTime(this.perfLogger.getStartTime("TezGetSession"));
        record.setExecutionDuration(this.perfLogger.getRunDagDuration());
        record.setExecutionStartTime(this.perfLogger.getStartTime("TezRunDag"));
    }

    private void enrichFromServiceContext(Record record) {
        record.setClusterId(this.serviceContext.getClusterId());
        record.setServerAddress(this.serviceContext.getHost());
        record.setServerPort(this.serviceContext.getPort());
    }

    private void enrichFromQueryState(QueryState queryState, Record record) {
        record.setQueryId(queryState.getQueryId());
        record.setQuerySql(queryState.getQueryString());
    }

    private void enrichFromQueryInfo(QueryInfo queryInfo, Record record) {
        if (queryInfo == null) {
            return;
        }
        record.setOperationId(queryInfo.getOperationId());
        record.setExecutionEngine(queryInfo.getExecutionEngine());
        record.setQueryState(queryInfo.getState());
        record.setQueryStartTime(queryInfo.getBeginTime());
        if (queryInfo.getEndTime() != null) {
            record.setQueryEndTime(queryInfo.getEndTime());
        }
        record.setTotalTime(queryInfo.getElapsedTime());
    }

    private void enrichFromRuntimeContext(TezRuntimeContext runtimeContext, Record record) {
        if (runtimeContext == null || runtimeContext.getDagId() == null) {
            this.setInvalidValuesForRuntimeFields(record);
            return;
        }
        record.setExecutionMode(runtimeContext.getExecutionMode());
        record.setDagId(runtimeContext.getDagId());
        record.setTezApplicationId(runtimeContext.getApplicationId());
        record.setTezSessionId(runtimeContext.getSessionId());
        record.setTezAmAddress(runtimeContext.getAmAddress());
        record.setExecSummary(runtimeContext.getMonitor().logger().getQuerySummary());
        record.setTotalNumberOfTasks((int)runtimeContext.getCounter(DAGCounter.class.getName(), DAGCounter.TOTAL_LAUNCHED_TASKS.name()));
        record.setNumberOfSucceededTasks((int)runtimeContext.getCounter(DAGCounter.class.getName(), DAGCounter.NUM_SUCCEEDED_TASKS.name()));
        record.setNumberOfKilledTasks((int)runtimeContext.getCounter(DAGCounter.class.getName(), DAGCounter.NUM_KILLED_TASKS.name()));
        record.setNumberOfFailedTasks((int)runtimeContext.getCounter(DAGCounter.class.getName(), DAGCounter.NUM_FAILED_TASKS.name()));
        record.setTaskDurationMillis(runtimeContext.getCounter(DAGCounter.class.getName(), DAGCounter.WALL_CLOCK_MILLIS.name()));
        record.setNodeUsedCount((int)runtimeContext.getCounter(DAGCounter.class.getName(), DAGCounter.NODE_USED_COUNT.name()));
        record.setNodeTotalCount((int)runtimeContext.getCounter(DAGCounter.class.getName(), DAGCounter.NODE_TOTAL_COUNT.name()));
        record.setReduceInputGroups(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.REDUCE_INPUT_GROUPS.name()));
        record.setReduceInputRecords(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.REDUCE_INPUT_RECORDS.name()));
        record.setSpilledRecords(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.SPILLED_RECORDS.name()));
        record.setNumShuffledInputs(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.NUM_SHUFFLED_INPUTS.name()));
        record.setNumFailedShuffleInputs(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.NUM_FAILED_SHUFFLE_INPUTS.name()));
        record.setInputRecordsProcessed(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.INPUT_RECORDS_PROCESSED.name()));
        record.setInputSplitLengthBytes(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.INPUT_SPLIT_LENGTH_BYTES.name()));
        record.setOutputRecords(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.OUTPUT_RECORDS.name()));
        record.setOutputBytesPhysical(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.OUTPUT_BYTES_PHYSICAL.name()));
        record.setShuffleChunkCount(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.SHUFFLE_CHUNK_COUNT.name()));
        record.setShuffleBytes(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.SHUFFLE_BYTES.name()));
        record.setShuffleBytesDiskDirect(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.SHUFFLE_BYTES_DISK_DIRECT.name()));
        record.setShufflePhaseTime(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.SHUFFLE_PHASE_TIME.name()));
        record.setMergePhaseTime(runtimeContext.getCounter(TaskCounter.class.getName(), TaskCounter.MERGE_PHASE_TIME.name()));
    }

    private void enrichFromQueryProperties(QueryProperties queryProperties, Record record) {
        if (queryProperties == null) {
            return;
        }
        record.setUsedTables(queryProperties.getUsedTables());
    }

    private void setInvalidValuesForRuntimeFields(Record record) {
        record.setTotalNumberOfTasks(-1);
        record.setNumberOfSucceededTasks(-1);
        record.setNumberOfKilledTasks(-1);
        record.setNumberOfFailedTasks(-1);
        record.setTaskDurationMillis(-1L);
        record.setNodeUsedCount(-1);
        record.setNodeTotalCount(-1);
        record.setReduceInputGroups(-1L);
        record.setReduceInputRecords(-1L);
        record.setSpilledRecords(-1L);
        record.setNumShuffledInputs(-1L);
        record.setNumFailedShuffleInputs(-1L);
        record.setInputRecordsProcessed(-1L);
        record.setInputSplitLengthBytes(-1L);
        record.setOutputRecords(-1L);
        record.setOutputBytesPhysical(-1L);
        record.setShuffleChunkCount(-1L);
        record.setShuffleBytes(-1L);
        record.setShuffleBytesDiskDirect(-1L);
        record.setShufflePhaseTime(-1L);
        record.setMergePhaseTime(-1L);
    }

    public static enum SessionType {
        HIVESERVER2,
        OTHER;

    }
}

