/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.events.PreDropDataConnectorEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropDataConnectorEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(DropDataConnectorEvent.class);
    private String COMMAND_STR = "drop connector";

    public DropDataConnectorEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.DROPDATACONNECTOR, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        LOG.debug("==> DropDataConnectorEvent.getInputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreDropDataConnectorEvent event = (PreDropDataConnectorEvent)this.preEventContext;
        DataConnector connector = event.getDataConnector();
        ret.add(this.getHivePrivilegeObject(connector));
        this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, connector);
        LOG.debug("<== DropDataConnectorEvent.getInputHObjs(): ret={}", ret);
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        return this.getInputHObjs();
    }

    private String buildCommandString(String cmdStr, DataConnector connector) {
        Object ret = cmdStr;
        if (connector != null) {
            String dcName = connector.getName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty((CharSequence)dcName) ? " " + dcName : "");
        }
        return ret;
    }
}

