/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.PrivateHookContext;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorStatsReaderHook
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger(OperatorStatsReaderHook.class);
    private boolean collectOnSuccess;

    @Override
    public void run(HookContext hookContext) throws Exception {
        if (hookContext.getHookType() == HookContext.HookType.PRE_EXEC_HOOK) {
            return;
        }
        if (hookContext.getHookType() == HookContext.HookType.POST_EXEC_HOOK && !this.isCollectOnSuccess()) {
            return;
        }
        HiveConf conf = hookContext.getConf();
        QueryPlan plan = hookContext.getQueryPlan();
        List<TezTask> rootTasks = Utilities.getTezTasks(plan.getRootTasks());
        for (TezTask tezTask : rootTasks) {
            List<BaseWork> baseWorks = ((TezWork)tezTask.getWork()).getAllWork();
            for (BaseWork baseWork : baseWorks) {
                String vertexName = baseWork.getName();
                LOG.debug("Reading runtime statistics for tez vertex task: {}", (Object)vertexName);
                TezCounters counters = tezTask.getTezCounters();
                if (counters == null) continue;
                String groupName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COUNTER_GROUP);
                for (Operator<?> op : baseWork.getAllOperators()) {
                    String operatorId = op.getOperatorId();
                    OperatorStats operatorStats = null;
                    String counterName = Operator.Counter.RECORDS_OUT_OPERATOR.toString() + "_" + operatorId;
                    TezCounter tezCounter = ((CounterGroup)counters.getGroup(groupName)).findCounter(counterName, false);
                    if (tezCounter != null) {
                        if (operatorStats == null) {
                            operatorStats = new OperatorStats(operatorId);
                        }
                        operatorStats.setOutputRecords(tezCounter.getValue());
                    }
                    if (operatorStats != null) {
                        ((PrivateHookContext)hookContext).getContext().getPlanMapper().link(op, operatorStats);
                        continue;
                    }
                    LOG.debug("Unable to get statistics for vertex: {} opId: {} groupName: {}", new Object[]{vertexName, operatorId, groupName});
                }
            }
        }
    }

    public boolean isCollectOnSuccess() {
        return this.collectOnSuccess;
    }

    public void setCollectOnSuccess(boolean collectOnSuccess) {
        this.collectOnSuccess = collectOnSuccess;
    }
}

