/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.OrcFileMerger;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MergeCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)MergeCompactor.class.getName());

    MergeCompactor() {
    }

    @Override
    public boolean run(CompactorContext context) throws IOException, HiveException, InterruptedException {
        HiveConf hiveConf = context.getConf();
        Table table = context.getTable();
        AcidDirectory dir = context.getAcidDirectory();
        ValidWriteIdList writeIds = context.getValidWriteIdList();
        StorageDescriptor storageDescriptor = context.getSd();
        CompactionInfo compactionInfo = context.getCompactionInfo();
        if (this.isMergeCompaction(hiveConf, dir, storageDescriptor)) {
            Path outputDirPath = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, hiveConf, compactionInfo.isMajorCompaction(), false, dir);
            try {
                return this.mergeFiles(hiveConf, compactionInfo.isMajorCompaction(), dir, outputDirPath, AcidUtils.isInsertOnlyTable(table.getParameters()));
            }
            catch (Throwable t) {
                FileSystem fs = outputDirPath.getFileSystem((Configuration)hiveConf);
                if (fs.exists(outputDirPath)) {
                    fs.delete(outputDirPath, true);
                }
                return false;
            }
        }
        return false;
    }

    private boolean isMergeCompaction(HiveConf conf, AcidDirectory directory, StorageDescriptor storageDescriptor) {
        return HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MERGE_COMPACTION_ENABLED) && storageDescriptor.getOutputFormat().equalsIgnoreCase("org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat") && !this.hasDeleteOrAbortedDirectories(directory);
    }

    private boolean hasDeleteOrAbortedDirectories(AcidDirectory directory) {
        if (!directory.getCurrentDirectories().isEmpty()) {
            return directory.getCurrentDirectories().stream().anyMatch(AcidUtils.ParsedDeltaLight::isDeleteDelta) || !directory.getAbortedDirectories().isEmpty();
        }
        return true;
    }

    private Map<Integer, List<Reader>> matchBucketIdToBucketFiles(HiveConf conf, AcidDirectory dir, boolean includeBaseDir, boolean isMm) throws IOException {
        HashMap<Integer, List<Reader>> result = new HashMap<Integer, List<Reader>>();
        if (includeBaseDir && dir.getBaseDirectory() != null) {
            result.putAll(this.getBucketFiles(conf, dir.getBaseDirectory(), isMm));
        }
        for (AcidUtils.ParsedDelta deltaDir : dir.getCurrentDirectories()) {
            Path deltaDirPath = deltaDir.getPath();
            Map<Integer, List<Reader>> intermediateResult = this.getBucketFiles(conf, deltaDirPath, isMm);
            intermediateResult.forEach((k, v) -> result.merge((Integer)k, (List<Reader>)v, (v1, v2) -> {
                v1.addAll(v2);
                return v1;
            }));
        }
        return result;
    }

    private Map<Integer, List<Reader>> getBucketFiles(HiveConf conf, Path dirPath, boolean isMm) throws IOException {
        FileStatus[] fileStatuses;
        HashMap<Integer, List<Reader>> bucketIdToBucketFilePath = new HashMap<Integer, List<Reader>>();
        FileSystem fs = dirPath.getFileSystem((Configuration)conf);
        for (FileStatus f : fileStatuses = fs.listStatus(dirPath, isMm ? AcidUtils.originalBucketFilter : AcidUtils.bucketFileFilter)) {
            Matcher matcher;
            Path fPath = f.getPath();
            Matcher matcher2 = matcher = isMm ? AcidUtils.LEGACY_BUCKET_DIGIT_PATTERN.matcher(fPath.getName()) : AcidUtils.BUCKET_PATTERN.matcher(fPath.getName());
            if (!matcher.find()) {
                String errorMessage = String.format("Found a bucket file which did not match the bucket pattern! %s Matcher=%s", fPath, matcher);
                LOG.error(errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
            int bucketNum = matcher.groupCount() > 0 ? Integer.parseInt(matcher.group(1)) : Integer.parseInt(matcher.group());
            bucketIdToBucketFilePath.computeIfAbsent(bucketNum, ArrayList::new);
            Reader reader = OrcFile.createReader(fs, fPath);
            bucketIdToBucketFilePath.computeIfPresent(bucketNum, (k, v) -> v).add(reader);
        }
        return bucketIdToBucketFilePath;
    }

    private boolean mergeFiles(HiveConf conf, boolean includeBaseDir, AcidDirectory dir, Path outputDirPath, boolean isMm) throws IOException {
        Map<Integer, List<Reader>> bucketIdToBucketFiles = this.matchBucketIdToBucketFiles(conf, dir, includeBaseDir, isMm);
        OrcFileMerger fileMerger = new OrcFileMerger((Configuration)conf);
        boolean isCompatible = bucketIdToBucketFiles.values().stream().allMatch(fileMerger::checkCompatibility);
        if (isCompatible) {
            for (Map.Entry<Integer, List<Reader>> e : bucketIdToBucketFiles.entrySet()) {
                Path path = isMm ? new Path(outputDirPath, String.format("%06d", e.getKey()) + "_0") : new Path(outputDirPath, "bucket_" + String.format("%05d", e.getKey()));
                fileMerger.mergeFiles(e.getValue(), path);
            }
            return true;
        }
        return false;
    }
}

