/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.Compactor;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryCompactor
implements Compactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)QueryCompactor.class.getName());

    protected void commitCompaction(String tmpTableName, HiveConf conf) throws IOException, HiveException {
    }

    protected SessionState setupQueryCompactionSession(HiveConf conf, CompactionInfo compactionInfo, Map<String, String> tblProperties) {
        String queueName = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPACTOR_JOB_QUEUE);
        if (queueName != null && queueName.length() > 0) {
            conf.set("tez.queue.name", queueName);
        }
        Util.disableLlapCaching(conf);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_MATERIALIZED_VIEW_ENABLE_AUTO_REWRITING, false);
        conf.set(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT.varname, "column");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_HDFS_ENCRYPTION_SHIM_CACHE_ON, false);
        CompactorUtil.overrideConfProps(conf, compactionInfo, tblProperties);
        String user = compactionInfo.runAs;
        SessionState sessionState = DriverUtils.setUpAndStartSessionState(conf, user);
        sessionState.setCompaction(true);
        return sessionState;
    }

    protected HiveConf setUpDriverSession(HiveConf hiveConf) {
        return new HiveConf(hiveConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runCompactionQueries(HiveConf conf, String tmpTableName, CompactionInfo compactionInfo, List<Path> resultDirs, List<String> createQueries, List<String> compactionQueries, List<String> dropQueries, Map<String, String> tblProperties) throws IOException {
        SessionState sessionState = this.setupQueryCompactionSession(conf, compactionInfo, tblProperties);
        try {
            for (String query : createQueries) {
                try {
                    LOG.info("Running {} compaction query into temp table with query: {}", (Object)compactionInfo.type, (Object)query);
                    DriverUtils.runOnDriver(conf, sessionState, query);
                }
                catch (Exception ex) {
                    Throwable cause;
                    for (cause = ex; cause != null && !(cause instanceof AlreadyExistsException); cause = cause.getCause()) {
                    }
                    if (cause != null) continue;
                    throw new IOException(ex);
                }
            }
            for (String query : compactionQueries) {
                LOG.info("Running {} compaction via query: {}", (Object)compactionInfo.type, (Object)query);
                if (CompactionType.MINOR.equals((Object)compactionInfo.type)) {
                    conf.set("hive.optimize.bucketingsorting", "false");
                    conf.set("hive.vectorized.execution.enabled", "false");
                }
                DriverUtils.runOnDriver(conf, sessionState, query);
            }
            this.commitCompaction(tmpTableName, conf);
            return;
        }
        catch (HiveException e) {
            LOG.error("Error doing query based {} compaction", (Object)compactionInfo.type, (Object)e);
            this.removeResultDirs(resultDirs, conf);
            throw new IOException(e);
        }
        finally {
            try {
                for (String query : dropQueries) {
                    LOG.info("Running {} compaction query into temp table with query: {}", (Object)compactionInfo.type, (Object)query);
                    DriverUtils.runOnDriver(conf, sessionState, query);
                }
            }
            catch (HiveException e) {
                LOG.error("Unable to drop temp table {} which was created for running {} compaction", (Object)tmpTableName, (Object)compactionInfo.type);
                LOG.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                sessionState.setCompaction(false);
            }
        }
    }

    protected String getTempTableName(org.apache.hadoop.hive.metastore.api.Table table) {
        return table.getDbName() + ".tmp_compactor_" + table.getTableName() + "_" + System.currentTimeMillis();
    }

    private void removeResultDirs(List<Path> resultDirPaths, HiveConf conf) throws IOException {
        for (Path path : resultDirPaths) {
            LOG.info("Compaction failed, removing directory: " + path.toString());
            Util.cleanupEmptyDir(conf, path);
        }
    }

    public static class Util {
        public static Path getCompactionResultDir(StorageDescriptor sd, ValidWriteIdList writeIds, HiveConf conf, boolean writingBase, boolean createDeleteDelta, AcidDirectory directory) {
            long minWriteID = writingBase ? 1L : Util.getMinWriteID(directory);
            long highWatermark = writeIds.getHighWatermark();
            long compactorTxnId = Compactor.getCompactorTxnId((Configuration)conf);
            AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)conf).isCompressed(false).minimumWriteId(minWriteID).maximumWriteId(highWatermark).statementId(-1).visibilityTxnId(compactorTxnId).writingBase(writingBase).writingDeleteDelta(createDeleteDelta);
            Path location = new Path(sd.getLocation());
            return AcidUtils.baseOrDeltaSubdirPath(location, options);
        }

        private static long getMinWriteID(AcidDirectory directory) {
            long minWriteID = Long.MAX_VALUE;
            for (AcidUtils.ParsedDelta delta : directory.getCurrentDirectories()) {
                minWriteID = Math.min(delta.getMinWriteId(), minWriteID);
                if (delta.isDeleteDelta()) continue;
                break;
            }
            return minWriteID;
        }

        private static void disableLlapCaching(HiveConf conf) {
            String llapIOETLSkipFormat = conf.getVar(HiveConf.ConfVars.LLAP_IO_ETL_SKIP_FORMAT);
            if (!"none".equals(llapIOETLSkipFormat)) {
                conf.setVar(HiveConf.ConfVars.LLAP_IO_ETL_SKIP_FORMAT, "all");
            }
        }

        static void cleanupEmptyTableDir(HiveConf conf, String tmpTableName) throws IOException, HiveException {
            Table tmpTable = Hive.get().getTable(tmpTableName);
            if (tmpTable != null) {
                Util.cleanupEmptyDir(conf, new Path(tmpTable.getSd().getLocation()));
            }
        }

        static void cleanupEmptyDir(HiveConf conf, Path path) throws IOException {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            try {
                if (!fs.listFiles(path, false).hasNext()) {
                    fs.delete(path, true);
                }
            }
            catch (FileNotFoundException e) {
                LOG.warn("Ignored exception during cleanup {}", (Object)path, (Object)e);
            }
        }

        static void removeFilesForMmTable(HiveConf conf, AcidDirectory dir) throws IOException {
            List<Path> filesToDelete = dir.getAbortedDirectories();
            if (filesToDelete.size() < 1) {
                return;
            }
            LOG.info("About to remove " + filesToDelete.size() + " aborted directories from " + String.valueOf(dir));
            FileSystem fs = filesToDelete.get(0).getFileSystem((Configuration)conf);
            for (Path dead : filesToDelete) {
                LOG.debug("Going to delete path " + dead.toString());
                fs.delete(dead, true);
            }
        }
    }
}

