/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFMethodResolver;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToLong;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.udf.TimestampCastRestrictorResolver;
import org.apache.hadoop.hive.ql.udf.UDFUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

@VectorizedExpressions(value={CastTimestampToLong.class, CastDoubleToLong.class, CastDecimalToLong.class, CastStringToLong.class})
@Description(name="int", value="_FUNC_(x) - converts it's parameter to _FUNC_", extended="- x is NULL -> NULL\n- byte, short, integer, long, timestamp:\n  x fits into the type _FUNC_ -> integer part of x\n  undefined otherwise\n- boolean:\n  true  -> 1\n  false -> 0\n- string:\n  x is a valid integer -> x\n  NULL otherwise\nExample:\n   > SELECT _FUNC_(true);\n  1")
public class UDFToInteger
extends UDF {
    private final IntWritable intWritable = new IntWritable();

    public UDFMethodResolver getResolver() {
        return new TimestampCastRestrictorResolver(super.getResolver());
    }

    public IntWritable evaluate(NullWritable i) {
        return null;
    }

    public IntWritable evaluate(BooleanWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set(i.get() ? 1 : 0);
        return this.intWritable;
    }

    public IntWritable evaluate(ByteWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(ShortWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(LongWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(FloatWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        this.intWritable.set((int)i.get());
        return this.intWritable;
    }

    public IntWritable evaluate(Text i) {
        if (i == null) {
            return null;
        }
        if (!LazyUtils.isNumberMaybe((byte[])i.getBytes(), (int)0, (int)i.getLength())) {
            return null;
        }
        try {
            this.intWritable.set(LazyInteger.parseInt((byte[])i.getBytes(), (int)0, (int)i.getLength(), (int)10, (boolean)true));
            return this.intWritable;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public IntWritable evaluate(TimestampWritableV2 i) {
        if (i == null) {
            return null;
        }
        long longValue = UDFUtils.getTimestampTZFromTimestamp(i.getTimestamp()).getEpochSecond();
        int intValue = (int)longValue;
        if ((long)intValue != longValue) {
            return null;
        }
        this.intWritable.set(intValue);
        return this.intWritable;
    }

    public IntWritable evaluate(HiveDecimalWritable i) {
        if (i == null || !i.isSet() || !i.isInt()) {
            return null;
        }
        this.intWritable.set(i.intValue());
        return this.intWritable;
    }

    public IntWritable evaluate(RecordIdentifier i) {
        if (i == null) {
            return null;
        }
        BucketCodec decoder = BucketCodec.determineVersion(i.getBucketProperty());
        this.intWritable.set(decoder.decodeWriterId(i.getBucketProperty()));
        return this.intWritable;
    }
}

