/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public abstract class AbstractGenericUDFArrayBase
extends GenericUDF {
    static final int ARRAY_IDX = 0;
    private final int minArgCount;
    private final int maxArgCount;
    private final ObjectInspector.Category outputCategory;
    private final String functionName;
    transient ListObjectInspector arrayOI;
    transient ObjectInspector[] argumentOIs;
    transient ObjectInspector arrayElementOI;
    transient ObjectInspectorConverters.Converter converter;

    protected AbstractGenericUDFArrayBase(String functionName, int minArgCount, int maxArgCount, ObjectInspector.Category outputCategory) {
        this.functionName = functionName;
        this.minArgCount = minArgCount;
        this.maxArgCount = maxArgCount;
        this.outputCategory = outputCategory;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, this.minArgCount, this.maxArgCount);
        this.checkArgCategory(arguments, 0, ObjectInspector.Category.LIST, this.functionName, "array");
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.argumentOIs = arguments;
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        if (this.outputCategory == ObjectInspector.Category.LIST) {
            return this.initListOI(arguments);
        }
        return this.initOI(arguments);
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.functionName.toLowerCase(), children);
    }

    void checkArgCategory(ObjectInspector[] arguments, int idx, ObjectInspector.Category category, String functionName, String typeName) throws UDFArgumentTypeException {
        if (!arguments[idx].getCategory().equals((Object)category)) {
            throw new UDFArgumentTypeException(idx, "\"" + typeName + "\" expected at function " + functionName + ", but \"" + arguments[idx].getTypeName() + "\" is found");
        }
    }

    void checkArgIntPrimitiveCategory(PrimitiveObjectInspector objectInspector, String functionName, int idx) throws UDFArgumentTypeException {
        switch (objectInspector.getPrimitiveCategory()) {
            case SHORT: 
            case INT: 
            case LONG: {
                break;
            }
            default: {
                throw new UDFArgumentTypeException(0, "Argument " + idx + " of function " + functionName + " must be \"smallint\" or \"int\" or \"bigint\", but \"" + objectInspector.getTypeName() + "\" was found.");
            }
        }
    }

    ObjectInspector initOI(ObjectInspector[] arguments) {
        GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        ObjectInspector elementObjectInspector = ((ListObjectInspector)arguments[0]).getListElementObjectInspector();
        ObjectInspector returnOI = returnOIResolver.get(elementObjectInspector);
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)elementObjectInspector, (ObjectInspector)returnOI);
        return returnOI;
    }

    ObjectInspector initListOI(ObjectInspector[] arguments) {
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.initOI(arguments));
    }

    void checkValueAndListElementTypes(ObjectInspector arrayElementOI, String functionName, ObjectInspector valueOI, int elementIndex) throws UDFArgumentTypeException {
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)arrayElementOI, (ObjectInspector)valueOI)) {
            throw new UDFArgumentTypeException(elementIndex, String.format("%s type element is expected at function %s(array<%s>,%s), but %s is found", arrayElementOI.getTypeName(), functionName, arrayElementOI.getTypeName(), arrayElementOI.getTypeName(), valueOI.getTypeName()));
        }
    }
}

