/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public abstract class GenericUDAFStreamingEvaluator<T1>
extends GenericUDAFEvaluator
implements ISupportStreamingModeForWindowing {
    protected final GenericUDAFEvaluator wrappedEval;
    protected final WindowFrameDef wFrameDef;

    public GenericUDAFStreamingEvaluator(GenericUDAFEvaluator wrappedEval, WindowFrameDef wFrameDef) {
        this.wrappedEval = wrappedEval;
        this.wFrameDef = wFrameDef;
        this.mode = wrappedEval.mode;
    }

    @Override
    public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
        return this.wrappedEval.init(m, parameters);
    }

    @Override
    public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        StreamingState ss = (StreamingState)agg;
        this.wrappedEval.reset(ss.wrappedBuf);
        ss.reset();
    }

    @Override
    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        throw new HiveException(this.getClass().getSimpleName() + ": terminatePartial not supported");
    }

    @Override
    public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
        throw new HiveException(this.getClass().getSimpleName() + ": merge not supported");
    }

    @Override
    public Object getNextResult(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        StreamingState ss = (StreamingState)agg;
        if (!ss.results.isEmpty()) {
            Object res = ss.results.remove(0);
            if (res == null) {
                return ISupportStreamingModeForWindowing.NULL_RESULT;
            }
            return res;
        }
        return null;
    }

    class StreamingState
    extends GenericUDAFEvaluator.AbstractAggregationBuffer {
        final GenericUDAFEvaluator.AggregationBuffer wrappedBuf;
        final List<T1> results;
        int numRows;

        StreamingState(GenericUDAFEvaluator.AggregationBuffer buf) {
            this.wrappedBuf = buf;
            this.results = new ArrayList();
            this.numRows = 0;
        }

        protected void reset() {
            this.results.clear();
            this.numRows = 0;
        }

        public boolean hasResultReady() {
            return this.numRows >= GenericUDAFStreamingEvaluator.this.wFrameDef.getEnd().getRelativeOffset();
        }
    }

    public static abstract class SumAvgEnhancer<T1, T2>
    extends GenericUDAFStreamingEvaluator<T1> {
        public SumAvgEnhancer(GenericUDAFEvaluator wrappedEval, WindowFrameDef wFrameDef) {
            super(wrappedEval, wFrameDef);
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            GenericUDAFEvaluator.AggregationBuffer underlying = this.wrappedEval.getNewAggregationBuffer();
            return new SumAvgStreamingState(underlying);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            SumAvgStreamingState ss = (SumAvgStreamingState)agg;
            this.wrappedEval.iterate(ss.wrappedBuf, parameters);
            if (ss.numRows == 0) {
                for (int i = this.wFrameDef.getEnd().getRelativeOffset(); i < 0; ++i) {
                    ss.results.add(null);
                }
            }
            if (ss.hasResultReady()) {
                ss.results.add(this.getNextResult(ss));
            }
            if (!this.wFrameDef.isStartUnbounded() && ss.numRows + 1 >= this.wFrameDef.getStart().getRelativeOffset()) {
                ss.intermediateVals.add(this.getCurrentIntermediateResult(ss));
            }
            ++ss.numRows;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            int i;
            SumAvgStreamingState ss = (SumAvgStreamingState)agg;
            Object o = this.wrappedEval.terminate(ss.wrappedBuf);
            for (i = Math.max(0, this.wFrameDef.getStart().getRelativeOffset()); i < this.wFrameDef.getEnd().getRelativeOffset(); ++i) {
                if (ss.hasResultReady()) {
                    ss.results.add(this.getNextResult(ss));
                }
                ++ss.numRows;
            }
            for (i = 0; i < this.wFrameDef.getStart().getRelativeOffset(); ++i) {
                if (ss.hasResultReady()) {
                    ss.results.add(null);
                }
                ++ss.numRows;
            }
            return o;
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            throw new UnsupportedOperationException();
        }

        protected abstract T1 getNextResult(SumAvgStreamingState var1) throws HiveException;

        protected abstract T2 getCurrentIntermediateResult(SumAvgStreamingState var1) throws HiveException;

        class SumAvgStreamingState
        extends StreamingState {
            final List<T2> intermediateVals;

            SumAvgStreamingState(GenericUDAFEvaluator.AggregationBuffer buf) {
                super(buf);
                this.intermediateVals = new ArrayList();
            }

            @Override
            public int estimate() {
                if (!(this.wrappedBuf instanceof GenericUDAFEvaluator.AbstractAggregationBuffer)) {
                    return -1;
                }
                int underlying = ((GenericUDAFEvaluator.AbstractAggregationBuffer)this.wrappedBuf).estimate();
                if (underlying == -1) {
                    return -1;
                }
                if (SumAvgEnhancer.this.wFrameDef.isStartUnbounded()) {
                    return -1;
                }
                int wdwSz = SumAvgEnhancer.this.wFrameDef.getWindowSize();
                return underlying + underlying * wdwSz + underlying * wdwSz + 12;
            }

            @Override
            protected void reset() {
                this.intermediateVals.clear();
                super.reset();
            }

            public T2 retrieveNextIntermediateValue() {
                if (!SumAvgEnhancer.this.wFrameDef.getStart().isUnbounded() && !this.intermediateVals.isEmpty() && this.numRows >= SumAvgEnhancer.this.wFrameDef.getWindowSize()) {
                    return this.intermediateVals.remove(0);
                }
                return null;
            }
        }
    }
}

