/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ListIndexColColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ListIndexColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexDecimalCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexDecimalScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexDoubleCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexDoubleScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexLongCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexLongScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexStringCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMapIndexStringScalar;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="index", value="_FUNC_(a, n) - Returns the n-th element of a ")
@VectorizedExpressions(value={ListIndexColScalar.class, ListIndexColColumn.class, VectorUDFMapIndexStringScalar.class, VectorUDFMapIndexLongScalar.class, VectorUDFMapIndexDoubleScalar.class, VectorUDFMapIndexDecimalScalar.class, VectorUDFMapIndexStringCol.class, VectorUDFMapIndexLongCol.class, VectorUDFMapIndexDoubleCol.class, VectorUDFMapIndexDecimalCol.class})
public class GenericUDFIndex
extends GenericUDF {
    private transient MapObjectInspector mapOI;
    private transient ListObjectInspector listOI;
    private transient ObjectInspectorConverters.Converter converter;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector returnOI;
        WritableIntObjectInspector indexOI;
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function INDEX accepts exactly 2 arguments.");
        }
        if (arguments[0] instanceof MapObjectInspector) {
            this.mapOI = (MapObjectInspector)arguments[0];
            this.listOI = null;
        } else if (arguments[0] instanceof ListObjectInspector) {
            this.listOI = (ListObjectInspector)arguments[0];
            this.mapOI = null;
        } else {
            throw new UDFArgumentTypeException(0, "\"" + ObjectInspector.Category.MAP.toString().toLowerCase() + "\" or \"" + ObjectInspector.Category.LIST.toString().toLowerCase() + "\" is expected at function INDEX, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        if (!(arguments[1] instanceof PrimitiveObjectInspector)) {
            throw new UDFArgumentTypeException(1, "Primitive Type is expected but " + arguments[1].getTypeName() + "\" is found");
        }
        PrimitiveObjectInspector inputOI = (PrimitiveObjectInspector)arguments[1];
        if (this.mapOI != null) {
            indexOI = ObjectInspectorConverters.getConvertedOI((ObjectInspector)inputOI, (ObjectInspector)this.mapOI.getMapKeyObjectInspector());
            returnOI = this.mapOI.getMapValueObjectInspector();
        } else {
            indexOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
            returnOI = this.listOI.getListElementObjectInspector();
        }
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)inputOI, (ObjectInspector)indexOI);
        return returnOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 2);
        Object index = arguments[1].get();
        Object indexObject = this.converter.convert(index);
        if (indexObject == null) {
            return null;
        }
        if (this.mapOI != null) {
            return this.mapOI.getMapValueElement(arguments[0].get(), indexObject);
        }
        return this.listOI.getListElement(arguments[0].get(), ((IntWritable)indexObject).get());
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 2);
        return children[0] + "[" + children[1] + "]";
    }
}

