/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColUnaryMinus;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColUnaryMinusChecked;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncNegateDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColUnaryMinus;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColUnaryMinusChecked;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseUnary;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="-", value="_FUNC_ a - Returns -a")
@VectorizedExpressions(value={LongColUnaryMinus.class, DoubleColUnaryMinus.class, FuncNegateDecimalToDecimal.class, LongColUnaryMinusChecked.class, DoubleColUnaryMinusChecked.class})
public class GenericUDFOPNegative
extends GenericUDFBaseUnary {
    public GenericUDFOPNegative() {
        this.opDisplayName = "-";
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0] == null) {
            return null;
        }
        Object input = arguments[0].get();
        if (input == null) {
            return null;
        }
        if ((input = this.converter.convert(input)) == null) {
            return null;
        }
        switch (this.resultOI.getPrimitiveCategory()) {
            case BYTE: {
                this.byteWritable.set(-((ByteWritable)input).get());
                return this.byteWritable;
            }
            case SHORT: {
                this.shortWritable.set(-((ShortWritable)input).get());
                return this.shortWritable;
            }
            case INT: {
                this.intWritable.set(-((IntWritable)input).get());
                return this.intWritable;
            }
            case LONG: {
                this.longWritable.set(-((LongWritable)input).get());
                return this.longWritable;
            }
            case FLOAT: {
                this.floatWritable.set(-((FloatWritable)input).get());
                return this.floatWritable;
            }
            case DOUBLE: {
                this.doubleWritable.set(-((DoubleWritable)input).get());
                return this.doubleWritable;
            }
            case DECIMAL: {
                this.decimalWritable.set((HiveDecimalWritable)input);
                this.decimalWritable.mutateNegate();
                return this.decimalWritable;
            }
            case INTERVAL_YEAR_MONTH: {
                HiveIntervalYearMonth intervalYearMonth = ((HiveIntervalYearMonthWritable)input).getHiveIntervalYearMonth();
                this.intervalYearMonthWritable.set(intervalYearMonth.negate());
                return this.intervalYearMonthWritable;
            }
            case INTERVAL_DAY_TIME: {
                HiveIntervalDayTime intervalDayTime = ((HiveIntervalDayTimeWritable)input).getHiveIntervalDayTime();
                this.intervalDayTimeWritable.set(intervalDayTime.negate());
                return this.intervalDayTimeWritable;
            }
        }
        throw new RuntimeException("Unexpected type in evaluating " + this.opName + ": " + String.valueOf(this.resultOI.getPrimitiveCategory()));
    }
}

