/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UDFType(deterministic=false, runtimeConstant=true)
@Description(name="restrict_information_schema", value="_FUNC_() - Returns whether or not to enable information schema restriction. Currently it is enabled if either HS2 authorizer or metastore authorizer implements policy provider interface.")
@NDV(maxNdv=1L)
public class GenericUDFRestrictInformationSchema
extends GenericUDF {
    private static final Logger LOG = LoggerFactory.getLogger((String)GenericUDFRestrictInformationSchema.class.getName());
    protected BooleanWritable enabled;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 0) {
            throw new UDFArgumentLengthException("The function RestrictInformationSchema does not take any arguments, but found " + arguments.length);
        }
        if (this.enabled == null) {
            HiveConf hiveConf = SessionState.getSessionConf();
            boolean enableHS2PolicyProvider = false;
            boolean enableMetastorePolicyProvider = false;
            HiveAuthorizer authorizer = SessionState.get().getAuthorizerV2();
            try {
                if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED) && authorizer.getHivePolicyProvider() != null) {
                    enableHS2PolicyProvider = true;
                }
            }
            catch (HiveAuthzPluginException e) {
                LOG.warn("Error getting HivePolicyProvider", (Throwable)((Object)e));
            }
            if (!enableHS2PolicyProvider && MetastoreConf.getVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS) != null && !MetastoreConf.getVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS).isEmpty() && HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER) != null) {
                try {
                    List<HiveMetastoreAuthorizationProvider> authorizerProviders = HiveUtils.getMetaStoreAuthorizeProviderManagers((Configuration)hiveConf, HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER, SessionState.get().getAuthenticator());
                    for (HiveMetastoreAuthorizationProvider authProvider : authorizerProviders) {
                        if (authProvider.getHivePolicyProvider() == null) continue;
                        enableMetastorePolicyProvider = true;
                        break;
                    }
                }
                catch (HiveAuthzPluginException e) {
                    LOG.warn("Error getting HivePolicyProvider", (Throwable)((Object)e));
                }
                catch (HiveException e) {
                    LOG.warn("Error instantiating hive.security.metastore.authorization.manager", (Throwable)e);
                }
            }
            this.enabled = enableHS2PolicyProvider || enableMetastorePolicyProvider ? new BooleanWritable(true) : new BooleanWritable(false);
        }
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.enabled;
    }

    @Override
    public String getDisplayString(String[] children) {
        return "RESTRICT_INFORMATION_SCHEMA()";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFRestrictInformationSchema other = (GenericUDFRestrictInformationSchema)newInstance;
        if (this.enabled != null) {
            other.enabled = new BooleanWritable(this.enabled.get());
        }
    }
}

