/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.nio.ByteBuffer;
import org.datanucleus.store.types.converters.ArrayConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;

public class BooleanArrayByteBufferConverter
implements TypeConverter<boolean[], ByteBuffer> {
    private static final long serialVersionUID = -1034562477183576606L;

    @Override
    public ByteBuffer toDatastoreType(boolean[] memberValue) {
        if (memberValue == null) {
            return null;
        }
        byte[] bytes = ArrayConversionHelper.getByteArrayFromBooleanArray(memberValue);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public boolean[] toMemberType(ByteBuffer datastoreValue) {
        if (datastoreValue == null) {
            return null;
        }
        return ArrayConversionHelper.getBooleanArrayFromByteArray(datastoreValue.array());
    }
}

