/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Partitioning;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.types.Types;

public class MetadataColumns {
    public static final int FILE_PATH_COLUMN_ID = 0x7FFFFFFE;
    public static final String FILE_PATH_COLUMN_DOC = "Path of the file in which a row is stored";
    public static final Types.NestedField FILE_PATH = Types.NestedField.required(0x7FFFFFFE, "_file", Types.StringType.get(), "Path of the file in which a row is stored");
    public static final Types.NestedField ROW_POSITION = Types.NestedField.required(0x7FFFFFFD, "_pos", Types.LongType.get(), "Ordinal position of a row in the source data file");
    public static final Types.NestedField IS_DELETED = Types.NestedField.required(0x7FFFFFFC, "_deleted", Types.BooleanType.get(), "Whether the row has been deleted");
    public static final int SPEC_ID_COLUMN_ID = 0x7FFFFFFB;
    public static final String SPEC_ID_COLUMN_DOC = "Spec ID used to track the file containing a row";
    public static final Types.NestedField SPEC_ID = Types.NestedField.required(0x7FFFFFFB, "_spec_id", Types.IntegerType.get(), "Spec ID used to track the file containing a row");
    public static final int PARTITION_COLUMN_ID = 0x7FFFFFFA;
    public static final String PARTITION_COLUMN_NAME = "_partition";
    public static final String PARTITION_COLUMN_DOC = "Partition to which a row belongs to";
    public static final int CONTENT_OFFSET_COLUMN_ID = 0x7FFFFFF9;
    public static final int CONTENT_SIZE_IN_BYTES_COLUMN_ID = 0x7FFFFFF8;
    public static final Types.NestedField DELETE_FILE_PATH = Types.NestedField.required(2147483546, "file_path", Types.StringType.get(), "Path of a file in which a deleted row is stored");
    public static final Types.NestedField DELETE_FILE_POS = Types.NestedField.required(0x7FFFFF99, "pos", Types.LongType.get(), "Ordinal position of a deleted row in the data file");
    public static final String DELETE_FILE_ROW_FIELD_NAME = "row";
    public static final int DELETE_FILE_ROW_FIELD_ID = 2147483544;
    public static final String DELETE_FILE_ROW_DOC = "Deleted row values";
    public static final Types.NestedField CHANGE_TYPE = Types.NestedField.required(0x7FFFFF97, "_change_type", Types.StringType.get(), "Record type in changelog");
    public static final Types.NestedField CHANGE_ORDINAL = Types.NestedField.optional(2147483542, "_change_ordinal", Types.IntegerType.get(), "Change ordinal in changelog");
    public static final Types.NestedField COMMIT_SNAPSHOT_ID = Types.NestedField.optional(2147483541, "_commit_snapshot_id", Types.LongType.get(), "Commit snapshot ID");
    public static final Types.NestedField ROW_ID = Types.NestedField.optional(2147483540, "_row_id", Types.LongType.get(), "Implicit row ID that is automatically assigned");
    public static final Types.NestedField LAST_UPDATED_SEQUENCE_NUMBER = Types.NestedField.optional(2147483539, "_last_updated_sequence_number", Types.LongType.get(), "Sequence number when the row was last updated");
    private static final Map<String, Types.NestedField> META_COLUMNS = ImmutableMap.of(FILE_PATH.name(), FILE_PATH, ROW_POSITION.name(), ROW_POSITION, IS_DELETED.name(), IS_DELETED, SPEC_ID.name(), SPEC_ID, ROW_ID.name(), ROW_ID, LAST_UPDATED_SEQUENCE_NUMBER.name(), LAST_UPDATED_SEQUENCE_NUMBER);
    private static final Set<Integer> META_IDS = ImmutableSet.of(Integer.valueOf(FILE_PATH.fieldId()), Integer.valueOf(ROW_POSITION.fieldId()), Integer.valueOf(IS_DELETED.fieldId()), Integer.valueOf(SPEC_ID.fieldId()), Integer.valueOf(0x7FFFFFFA), Integer.valueOf(ROW_ID.fieldId()), new Integer[]{LAST_UPDATED_SEQUENCE_NUMBER.fieldId()});

    private MetadataColumns() {
    }

    public static Set<Integer> metadataFieldIds() {
        return META_IDS;
    }

    public static Types.NestedField metadataColumn(Table table, String name) {
        if (name.equals(PARTITION_COLUMN_NAME)) {
            return Types.NestedField.optional(0x7FFFFFFA, PARTITION_COLUMN_NAME, Partitioning.partitionType(table), PARTITION_COLUMN_DOC);
        }
        return META_COLUMNS.get(name);
    }

    public static boolean isMetadataColumn(String name) {
        return name.equals(PARTITION_COLUMN_NAME) || META_COLUMNS.containsKey(name);
    }

    public static boolean isMetadataColumn(int id) {
        return META_IDS.contains(id);
    }

    public static boolean nonMetadataColumn(String name) {
        return !MetadataColumns.isMetadataColumn(name);
    }
}

