/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryColumnStatsMerger
extends ColumnStatsMerger<byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryColumnStatsMerger.class);

    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        LOG.debug("Merging statistics: [aggregateColStats:{}, newColStats: {}]", (Object)aggregateColStats, (Object)newColStats);
        BinaryColumnStatsData aggregateData = aggregateColStats.getStatsData().getBinaryStats();
        BinaryColumnStatsData newData = newColStats.getStatsData().getBinaryStats();
        aggregateData.setMaxColLen(this.mergeMaxColLen(aggregateData.getMaxColLen(), newData.getMaxColLen()));
        aggregateData.setAvgColLen(this.mergeAvgColLen(aggregateData.getAvgColLen(), newData.getAvgColLen()));
        aggregateData.setNumNulls(this.mergeNumNulls(aggregateData.getNumNulls(), newData.getNumNulls()));
    }
}

