/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.function.Function;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class RemoveDuplicateCompleteTxnComponentsCommand
implements ParameterizedCommand {
    public static RemoveDuplicateCompleteTxnComponentsCommand INSTANCE = new RemoveDuplicateCompleteTxnComponentsCommand();

    private RemoveDuplicateCompleteTxnComponentsCommand() {
    }

    @Override
    public Function<Integer, Boolean> resultPolicy() {
        return null;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        switch (DatabaseProduct.dbType) {
            case MYSQL: 
            case SQLSERVER: {
                return "DELETE tc FROM \"COMPLETED_TXN_COMPONENTS\" tc INNER JOIN (    SELECT \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\",        MAX(\"CTC_WRITEID\") highestWriteId,        MAX(CASE WHEN \"CTC_UPDATE_DELETE\" = 'Y' THEN \"CTC_WRITEID\" END) updateWriteId    FROM \"COMPLETED_TXN_COMPONENTS\"    GROUP BY \"CTC_DATABASE\", \"CTC_TABLE\", \"CTC_PARTITION\") c ON       tc.\"CTC_DATABASE\" = c.\"CTC_DATABASE\"       AND tc.\"CTC_TABLE\" = c.\"CTC_TABLE\"      AND (tc.\"CTC_PARTITION\" = c.\"CTC_PARTITION\" OR (tc.\"CTC_PARTITION\" IS NULL AND c.\"CTC_PARTITION\" IS NULL)) WHERE tc.\"CTC_WRITEID\" < c.\"highestWriteId\" " + (DatabaseProduct.DbType.MYSQL == DatabaseProduct.dbType ? "  AND NOT tc.\"CTC_WRITEID\" <=> c.updateWriteId" : "  AND (tc.\"CTC_WRITEID\" != c.updateWriteId OR c.updateWriteId IS NULL)");
            }
            case DERBY: 
            case ORACLE: 
            case POSTGRES: 
            case CUSTOM: {
                String existsSubQuery = "EXISTS (    SELECT 1    FROM \"COMPLETED_TXN_COMPONENTS\" c    WHERE tc.\"CTC_DATABASE\" = c.\"CTC_DATABASE\"      AND tc.\"CTC_TABLE\" = c.\"CTC_TABLE\"      AND %s      AND (tc.\"CTC_UPDATE_DELETE\" = 'N' OR c.\"CTC_UPDATE_DELETE\" = 'Y')      AND tc.\"CTC_WRITEID\" < c.\"CTC_WRITEID\")";
                return "DELETE FROM \"COMPLETED_TXN_COMPONENTS\" tc WHERE " + String.format(existsSubQuery, "tc.\"CTC_PARTITION\" = c.\"CTC_PARTITION\"") + " OR " + String.format(existsSubQuery, "tc.\"CTC_PARTITION\" IS NULL AND c.\"CTC_PARTITION\" IS NULL");
            }
        }
        String msg = "Unknown database product: " + String.valueOf((Object)DatabaseProduct.dbType);
        throw new MetaException(msg);
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource();
    }
}

