/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.reactive;

import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.util.TextUtils;
import org.reactivestreams.Publisher;

public class ReactiveTestUtils {
    private static final byte[] RANGE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes(StandardCharsets.US_ASCII);

    public static Flowable<ByteBuffer> produceStream(long length) {
        return ReactiveTestUtils.produceStream(length, null);
    }

    public static Flowable<ByteBuffer> produceStream(long length, AtomicReference<String> hash) {
        return ReactiveTestUtils.produceStream(length, 131072, hash);
    }

    public static Flowable<ByteBuffer> produceStream(final long length, final int maximumBlockSize, final AtomicReference<String> hash) {
        return Flowable.generate((Consumer)new Consumer<Emitter<ByteBuffer>>(){
            final Random random;
            long bytesEmitted;
            final MessageDigest md;
            {
                this.random = new Random(length);
                this.md = ReactiveTestUtils.newMessageDigest();
            }

            public void accept(Emitter<ByteBuffer> emitter) {
                long remainingLength = length - this.bytesEmitted;
                if (remainingLength == 0L) {
                    emitter.onComplete();
                    if (hash != null) {
                        hash.set(TextUtils.toHexString((byte[])this.md.digest()));
                    }
                } else {
                    int bufferLength = (int)Math.min(remainingLength, (long)(1 + this.random.nextInt(maximumBlockSize)));
                    byte[] bs = new byte[bufferLength];
                    for (int i = 0; i < bufferLength; ++i) {
                        byte b;
                        bs[i] = b = RANGE[(int)(this.random.nextDouble() * (double)RANGE.length)];
                    }
                    if (hash != null) {
                        this.md.update(bs);
                    }
                    emitter.onNext((Object)ByteBuffer.wrap(bs));
                    this.bytesEmitted += (long)bufferLength;
                }
            }
        });
    }

    public static String getStreamHash(long length) {
        return TextUtils.toHexString((byte[])((StreamDescription)ReactiveTestUtils.consumeStream(ReactiveTestUtils.produceStream((long)length)).blockingGet()).md.digest());
    }

    public static Single<StreamDescription> consumeStream(Publisher<ByteBuffer> publisher) {
        StreamDescription seed = new StreamDescription(0L, ReactiveTestUtils.newMessageDigest());
        return Flowable.fromPublisher(publisher).reduce((Object)seed, (BiFunction)new BiFunction<StreamDescription, ByteBuffer, StreamDescription>(){

            public StreamDescription apply(StreamDescription desc, ByteBuffer byteBuffer) {
                long length = desc.length + (long)byteBuffer.remaining();
                desc.md.update(byteBuffer);
                return new StreamDescription(length, desc.md);
            }
        });
    }

    private static MessageDigest newMessageDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static class StreamDescription {
        public final long length;
        public final MessageDigest md;

        public StreamDescription(long length, MessageDigest md) {
            this.length = length;
            this.md = md;
        }
    }
}

