/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestByteArrayBuffer {
    TestByteArrayBuffer() {
    }

    @Test
    void testConstructor() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)0, (int)buffer.length());
        Assertions.assertNotNull((Object)buffer.array());
        Assertions.assertEquals((int)16, (int)buffer.array().length);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ByteArrayBuffer(-1));
    }

    @Test
    void testSimpleAppend() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)0, (int)buffer.length());
        byte[] b1 = buffer.toByteArray();
        Assertions.assertNotNull((Object)b1);
        Assertions.assertEquals((int)0, (int)b1.length);
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        byte[] tmp = new byte[]{1, 2, 3, 4};
        buffer.append(tmp, 0, tmp.length);
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)4, (int)buffer.length());
        Assertions.assertFalse((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
        byte[] b2 = buffer.toByteArray();
        Assertions.assertNotNull((Object)b2);
        Assertions.assertEquals((int)4, (int)b2.length);
        for (int i = 0; i < tmp.length; ++i) {
            Assertions.assertEquals((byte)tmp[i], (byte)b2[i]);
            Assertions.assertEquals((int)tmp[i], (int)buffer.byteAt(i));
        }
        buffer.clear();
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)0, (int)buffer.length());
        Assertions.assertTrue((boolean)buffer.isEmpty());
        Assertions.assertFalse((boolean)buffer.isFull());
    }

    @Test
    void testExpandAppend() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        byte[] tmp = new byte[]{1, 2, 3, 4};
        buffer.append(tmp, 0, 2);
        buffer.append(tmp, 0, 4);
        buffer.append(tmp, 0, 0);
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((int)6, (int)buffer.length());
        buffer.append(tmp, 0, 4);
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)10, (int)buffer.length());
    }

    @Test
    void testAppendHeapByteBuffer() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        ByteBuffer tmp = ByteBuffer.wrap(new byte[]{1, 2, 3, 4, 5, 6});
        buffer.append(tmp);
        Assertions.assertFalse((boolean)tmp.hasRemaining(), (String)"The input buffer should be drained");
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((int)6, (int)buffer.length());
        tmp.clear();
        buffer.append(tmp);
        Assertions.assertFalse((boolean)tmp.hasRemaining(), (String)"The input buffer should be drained");
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)12, (int)buffer.length());
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6}, (byte[])buffer.toByteArray());
    }

    @Test
    void testAppendHeapByteBufferWithOffset() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        ByteBuffer tmp = ByteBuffer.wrap(new byte[]{7, 7, 1, 2, 3, 4, 5, 6, 7, 7}, 2, 6).slice();
        Assertions.assertTrue((tmp.arrayOffset() > 0 ? 1 : 0) != 0, (String)"Validate this is testing a buffer with an array offset");
        buffer.append(tmp);
        Assertions.assertFalse((boolean)tmp.hasRemaining(), (String)"The input buffer should be drained");
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((int)6, (int)buffer.length());
        tmp.clear();
        Assertions.assertEquals((int)6, (int)tmp.remaining());
        buffer.append(tmp);
        Assertions.assertFalse((boolean)tmp.hasRemaining(), (String)"The input buffer should be drained");
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)12, (int)buffer.length());
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6}, (byte[])buffer.toByteArray());
    }

    @Test
    void testAppendDirectByteBuffer() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        ByteBuffer tmp = ByteBuffer.allocateDirect(6);
        tmp.put(new byte[]{1, 2, 3, 4, 5, 6}).flip();
        buffer.append(tmp);
        Assertions.assertFalse((boolean)tmp.hasRemaining(), (String)"The input buffer should be drained");
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((int)6, (int)buffer.length());
        tmp.clear();
        buffer.append(tmp);
        Assertions.assertFalse((boolean)tmp.hasRemaining(), (String)"The input buffer should be drained");
        Assertions.assertEquals((int)16, (int)buffer.capacity());
        Assertions.assertEquals((int)12, (int)buffer.length());
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6, 1, 2, 3, 4, 5, 6}, (byte[])buffer.toByteArray());
    }

    @Test
    void testInvalidAppend() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.append((byte[])null, 0, 0);
        byte[] tmp = new byte[]{1, 2, 3, 4};
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, -1, 0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, 8));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 10, Integer.MAX_VALUE));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 2, 4));
    }

    @Test
    void testAppendOneByte() {
        byte[] tmp;
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        for (byte element : tmp = new byte[]{1, 127, -1, -128, 1, -2}) {
            buffer.append((int)element);
        }
        Assertions.assertEquals((int)8, (int)buffer.capacity());
        Assertions.assertEquals((int)6, (int)buffer.length());
        for (int i = 0; i < tmp.length; ++i) {
            Assertions.assertEquals((int)tmp[i], (int)buffer.byteAt(i));
        }
    }

    @Test
    void testSetLength() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.setLength(2);
        Assertions.assertEquals((int)2, (int)buffer.length());
    }

    @Test
    void testSetInvalidLength() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.setLength(-2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.setLength(200));
    }

    @Test
    void testEnsureCapacity() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.ensureCapacity(2);
        Assertions.assertEquals((int)4, (int)buffer.capacity());
        buffer.ensureCapacity(8);
        Assertions.assertEquals((int)8, (int)buffer.capacity());
    }

    @Test
    void testIndexOf() {
        int COLON = 58;
        int COMMA = 44;
        byte[] bytes = "name1: value1; name2: value2".getBytes(StandardCharsets.US_ASCII);
        int index1 = 5;
        int index2 = 20;
        ByteArrayBuffer buffer = new ByteArrayBuffer(16);
        buffer.append(bytes, 0, bytes.length);
        Assertions.assertEquals((int)5, (int)buffer.indexOf((byte)58));
        Assertions.assertEquals((int)-1, (int)buffer.indexOf((byte)44));
        Assertions.assertEquals((int)5, (int)buffer.indexOf((byte)58, -1, 11));
        Assertions.assertEquals((int)5, (int)buffer.indexOf((byte)58, 0, 1000));
        Assertions.assertEquals((int)-1, (int)buffer.indexOf((byte)58, 2, 1));
        Assertions.assertEquals((int)20, (int)buffer.indexOf((byte)58, 6, buffer.length()));
    }

    @Test
    void testAppendCharArrayAsAscii() {
        String s1 = "stuff";
        String s2 = " and more stuff";
        char[] b1 = "stuff".toCharArray();
        char[] b2 = " and more stuff".toCharArray();
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        buffer.append(b1, 0, b1.length);
        buffer.append(b2, 0, b2.length);
        Assertions.assertEquals((Object)"stuff and more stuff", (Object)new String(buffer.toByteArray(), StandardCharsets.US_ASCII));
    }

    @Test
    void testAppendNullCharArray() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        buffer.append((char[])null, 0, 0);
        Assertions.assertEquals((int)0, (int)buffer.length());
    }

    @Test
    void testAppendEmptyCharArray() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        buffer.append(new char[0], 0, 0);
        Assertions.assertEquals((int)0, (int)buffer.length());
    }

    @Test
    void testAppendNullCharArrayBuffer() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        buffer.append((CharArrayBuffer)null, 0, 0);
        Assertions.assertEquals((int)0, (int)buffer.length());
    }

    @Test
    void testAppendNullByteBuffer() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(8);
        ByteBuffer nullBuffer = null;
        buffer.append(nullBuffer);
        Assertions.assertEquals((int)0, (int)buffer.length());
    }

    @Test
    void testInvalidAppendCharArrayAsAscii() {
        ByteArrayBuffer buffer = new ByteArrayBuffer(4);
        buffer.append((char[])null, 0, 0);
        char[] tmp = new char[]{'1', '2', '3', '4'};
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, -1, 0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, -1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 0, 8));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 10, Integer.MAX_VALUE));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> buffer.append(tmp, 2, 4));
    }

    @Test
    void testSerialization() throws Exception {
        ByteArrayBuffer orig = new ByteArrayBuffer(32);
        orig.append(1);
        orig.append(2);
        orig.append(3);
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
        }
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        ByteArrayBuffer clone = (ByteArrayBuffer)inStream.readObject();
        Assertions.assertEquals((int)orig.capacity(), (int)clone.capacity());
        Assertions.assertEquals((int)orig.length(), (int)clone.length());
        byte[] data = clone.toByteArray();
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)3, (int)data.length);
        Assertions.assertEquals((int)1, (int)data[0]);
        Assertions.assertEquals((int)2, (int)data[1]);
        Assertions.assertEquals((int)3, (int)data[2]);
    }

    @Test
    void testControlCharFiltering() {
        char[] chars = new char[256];
        for (int i = 0; i < 256; i = (int)((char)(i + 1))) {
            chars[i] = i;
        }
        byte[] bytes = TestByteArrayBuffer.asByteArray(chars);
        Assertions.assertEquals((Object)"?????????\t?????????????????????? !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~?????????????????????????????????\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff", (Object)new String(bytes, StandardCharsets.ISO_8859_1));
    }

    @Test
    void testUnicodeFiltering() {
        Assertions.assertEquals((Object)"?????", (Object)new String(TestByteArrayBuffer.asByteArray("\u0431\u0443\u043a\u0432\u044b".toCharArray()), StandardCharsets.ISO_8859_1));
        Assertions.assertEquals((Object)"????", (Object)new String(TestByteArrayBuffer.asByteArray("\u56db\u5b57\u719f\u8a9e".toCharArray()), StandardCharsets.ISO_8859_1));
        Assertions.assertEquals((Object)"?", (Object)new String(TestByteArrayBuffer.asByteArray("\u2603".toCharArray()), StandardCharsets.ISO_8859_1));
        Assertions.assertEquals((Object)"??", (Object)new String(TestByteArrayBuffer.asByteArray("\ud83d\ude00".toCharArray()), StandardCharsets.ISO_8859_1));
    }

    private static byte[] asByteArray(char[] chars) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(chars.length);
        byteArrayBuffer.append(chars, 0, chars.length);
        return byteArrayBuffer.toByteArray();
    }
}

