/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.cli.commands.cliconfig;

import static org.junit.jupiter.api.Assertions.assertAll;

import org.apache.ignite.internal.cli.commands.cliconfig.profile.CliConfigProfileListCommand;
import org.apache.ignite.internal.cli.config.ini.IniConfigManager;
import org.junit.jupiter.api.Test;

class CliConfigProfileListCommandTest extends CliConfigCommandTestBase {
    @Override
    protected Class<?> getCommandClass() {
        return CliConfigProfileListCommand.class;
    }

    @Test
    public void testWithDefaultProfile() {
        execute();

        String expectedResult = "owner" + System.lineSeparator()
                + "database" + System.lineSeparator();
        assertAll(
                () -> assertOutputIs(expectedResult),
                this::assertErrOutputIsEmpty
        );
    }

    @Test
    public void testSingleProfile() {
        configManagerProvider.configManager = new IniConfigManager(TestConfigManagerHelper.createOneSectionWithDefaultProfile());
        execute();

        String expectedResult = "default" + System.lineSeparator();
        assertAll(
                () -> assertOutputIs(expectedResult),
                this::assertErrOutputIsEmpty
        );
    }

    @Test
    public void testEmptyConfig() {
        configManagerProvider.configManager = new IniConfigManager(TestConfigManagerHelper.createEmptyConfig());
        execute();

        String expectedResult = "default" + System.lineSeparator();
        assertAll(
                () -> assertOutputIs(expectedResult),
                this::assertErrOutputIsEmpty
        );
    }
}
