/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorage;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.apache.ignite.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite.raft.jraft.util.Platform;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.Priority;
import org.rocksdb.RocksDB;

public class DefaultLogStorageFactory
implements LogStorageFactory {
    private static final IgniteLogger LOG = Loggers.forClass(DefaultLogStorageFactory.class);
    private final Path path;
    private final ExecutorService executorService;
    private RocksDB db;
    private DBOptions dbOptions;
    private ColumnFamilyHandle confHandle;
    private ColumnFamilyHandle dataHandle;

    public DefaultLogStorageFactory(Path path) {
        this.path = path;
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, (ThreadFactory)new NamedThreadFactory("raft-shared-log-storage-pool", LOG));
    }

    @Override
    public void start() {
        try {
            Files.createDirectories(this.path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create directory: " + this.path, e);
        }
        ArrayList columnFamilyHandles = new ArrayList();
        this.dbOptions = DefaultLogStorageFactory.createDbOptions();
        ColumnFamilyOptions cfOption = DefaultLogStorageFactory.createColumnFamilyOptions();
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = List.of(new ColumnFamilyDescriptor("Configuration".getBytes(StandardCharsets.UTF_8), cfOption), new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cfOption));
        try {
            this.db = RocksDB.open((DBOptions)this.dbOptions, (String)this.path.toString(), columnFamilyDescriptors, columnFamilyHandles);
            Env env = this.db.getEnv();
            env.setBackgroundThreads(Runtime.getRuntime().availableProcessors(), Priority.HIGH);
            env.setBackgroundThreads(Runtime.getRuntime().availableProcessors(), Priority.LOW);
            assert (columnFamilyHandles.size() == 2);
            this.confHandle = (ColumnFamilyHandle)columnFamilyHandles.get(0);
            this.dataHandle = (ColumnFamilyHandle)columnFamilyHandles.get(1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        ExecutorServiceHelper.shutdownAndAwaitTermination(this.executorService);
        IgniteUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.confHandle, this.dataHandle, this.db, this.dbOptions});
    }

    @Override
    public LogStorage createLogStorage(String groupId, RaftOptions raftOptions) {
        return new RocksDbSharedLogStorage(this.db, this.confHandle, this.dataHandle, groupId, raftOptions, this.executorService);
    }

    private static DBOptions createDbOptions() {
        return new DBOptions().setMaxBackgroundJobs(Runtime.getRuntime().availableProcessors() * 2).setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
    }

    private static ColumnFamilyOptions createColumnFamilyOptions() {
        ColumnFamilyOptions opts = new ColumnFamilyOptions();
        opts.setWriteBufferSize(0x4000000L);
        opts.setMaxWriteBufferNumber(5);
        opts.setMinWriteBufferNumberToMerge(1);
        opts.setLevel0FileNumCompactionTrigger(50);
        opts.setLevel0SlowdownWritesTrigger(100);
        opts.setLevel0StopWritesTrigger(200);
        opts.setMaxBytesForLevelBase(0xC8000000L);
        opts.setTargetFileSizeBase(0x14000000L);
        if (!Platform.isWindows()) {
            opts.setCompressionType(CompressionType.LZ4_COMPRESSION).setCompactionStyle(CompactionStyle.LEVEL).optimizeLevelStyleCompaction();
        }
        return opts;
    }
}

