/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.cli;

import java.util.Iterator;
import java.util.concurrent.Executor;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class ResetPeerRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ResetPeerRequest> {
    public ResetPeerRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.ResetPeerRequest request) {
        return request.peerId();
    }

    @Override
    protected String getGroupId(CliRequests.ResetPeerRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ResetPeerRequest request, IgniteCliRpcRequestClosure done) {
        Configuration newConf = new Configuration();
        Iterator<String> iterator = request.newPeersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerIdStr = iterator.next();
            if (peer.parse(peerIdStr)) {
                newConf.addPeer(peer);
                continue;
            }
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", peerIdStr);
        }
        LOG.info("Receive ResetPeerRequest to {} from {}, new conf is {}", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), newConf});
        Status st = ctx.node.resetPeers(newConf);
        return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), st);
    }

    @Override
    public String interest() {
        return CliRequests.ResetPeerRequest.class.getName();
    }
}

