/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.topology;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.cluster.topology.LogicalTopologyCall;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.decorators.PlainTopologyDecorator;
import org.apache.ignite.internal.cli.decorators.TopologyDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="logical")
public class LogicalTopologyReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @Inject
    private LogicalTopologyCall call;
    @Inject
    private ConnectToClusterQuestion question;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting"})
    private boolean plain;

    @Override
    public void run() {
        TopologyDecorator topologyDecorator = this.plain ? new PlainTopologyDecorator() : new TopologyDecorator();
        this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(UrlCallInput::new).then(Flows.fromCall(this.call)).exceptionHandler(new ClusterNotInitializedExceptionHandler("Cannot show logical topology", "cluster init")).print(topologyDecorator).start();
    }
}

