/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer;

import jakarta.inject.Singleton;
import java.util.Arrays;
import org.apache.ignite.internal.cli.core.repl.Session;
import org.apache.ignite.internal.cli.core.repl.completer.CompleterFilter;

@Singleton
public class DynamicCompleterFilter
implements CompleterFilter {
    private final Session session;

    public DynamicCompleterFilter(Session session) {
        this.session = session;
    }

    private static boolean optionTyped(String[] words) {
        String lastWord = words[words.length - 1];
        return lastWord.startsWith("-");
    }

    @Override
    public String[] filter(String[] words, String[] candidates) {
        return (String[])Arrays.stream(candidates).filter(candidate -> this.filterClusterUrl(words, (String)candidate)).filter(candidate -> this.filterHelp(words, (String)candidate)).toArray(String[]::new);
    }

    private boolean filterHelp(String[] words, String candidate) {
        if (DynamicCompleterFilter.optionTyped(words)) {
            return true;
        }
        return !candidate.equals("--help") && !candidate.equals("-h");
    }

    private boolean filterClusterUrl(String[] words, String candidate) {
        if (DynamicCompleterFilter.optionTyped(words)) {
            return true;
        }
        return !this.session.isConnectedToNode() || !candidate.equals("--cluster-endpoint-url") && !candidate.equals("--node-url");
    }
}

