/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.basic;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.ignite.internal.storage.DataRow;
import org.apache.ignite.internal.storage.SearchRow;

public class DelegatingDataRow
implements DataRow {
    private final SearchRow key;
    private final byte[] value;

    public DelegatingDataRow(SearchRow key, byte[] value) {
        assert (key != null);
        assert (value != null);
        this.key = key;
        this.value = value;
    }

    @Override
    public ByteBuffer key() {
        return this.key.key();
    }

    @Override
    public byte[] keyBytes() {
        return this.key.keyBytes();
    }

    @Override
    public ByteBuffer value() {
        return ByteBuffer.wrap(this.value);
    }

    @Override
    public byte[] valueBytes() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataRow)) {
            return false;
        }
        DataRow row = (DataRow)o;
        return Arrays.equals(this.keyBytes(), row.keyBytes()) && Arrays.equals(this.value, row.valueBytes());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.keyBytes());
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }
}

