/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.row.InternalTuple;

public class BinaryTuplePrefix
extends BinaryTupleReader
implements InternalTuple {
    private final BinaryTupleSchema schema;

    public BinaryTuplePrefix(BinaryTupleSchema schema, byte[] bytes) {
        super(schema.elementCount(), bytes);
        this.schema = schema;
    }

    public BinaryTuplePrefix(BinaryTupleSchema schema, ByteBuffer buffer) {
        super(schema.elementCount(), buffer);
        this.schema = schema;
    }

    public static BinaryTuplePrefix fromBinaryTuple(BinaryTuple tuple) {
        ByteBuffer tupleBuffer = tuple.byteBuffer();
        ByteBuffer prefixBuffer = ByteBuffer.allocate(tupleBuffer.remaining() + 4).order(ORDER).put(tupleBuffer).putInt(tuple.count()).flip();
        byte flags = prefixBuffer.get(0);
        prefixBuffer.put(0, (byte)(flags | 8));
        return new BinaryTuplePrefix(tuple.schema(), prefixBuffer);
    }

    @Override
    public int count() {
        return this.elementCount();
    }

    @Override
    public BigDecimal decimalValue(int index) {
        return this.decimalValue(index, this.schema.element((int)index).decimalScale);
    }

    public int elementCount() {
        ByteBuffer buffer = this.byteBuffer();
        return buffer.getInt(buffer.limit() - 4);
    }
}

