/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.reflection;

import java.util.Objects;
import org.apache.ignite.internal.schema.ByteBufferRow;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.marshaller.MarshallerException;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.schema.marshaller.RecordMarshaller;
import org.apache.ignite.internal.schema.marshaller.reflection.Marshaller;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.table.mapper.PojoMapper;
import org.jetbrains.annotations.NotNull;

public class RecordMarshallerImpl<R>
implements RecordMarshaller<R> {
    private final SchemaDescriptor schema;
    private final Marshaller keyMarsh;
    private final Marshaller recMarsh;
    private final Class<R> recClass;

    public RecordMarshallerImpl(SchemaDescriptor schema, @NotNull Mapper<R> mapper) {
        assert (mapper instanceof PojoMapper);
        this.schema = schema;
        this.recClass = mapper.targetType();
        this.keyMarsh = Marshaller.createMarshaller(schema.keyColumns().columns(), mapper, true);
        this.recMarsh = Marshaller.createMarshaller((Column[])ArrayUtils.concat((Object[])schema.keyColumns().columns(), (Object[])schema.valueColumns().columns()), mapper, false);
    }

    @Override
    public int schemaVersion() {
        return this.schema.version();
    }

    @Override
    public Row marshal(@NotNull R rec) throws MarshallerException {
        assert (this.recClass.isInstance(rec));
        RowAssembler asm = this.createAssembler(Objects.requireNonNull(rec), rec);
        this.recMarsh.writeObject(rec, asm);
        return new Row(this.schema, new ByteBufferRow(asm.toBytes()));
    }

    @Override
    public Row marshalKey(@NotNull R rec) throws MarshallerException {
        assert (this.recClass.isInstance(rec));
        RowAssembler asm = this.createAssembler(Objects.requireNonNull(rec), null);
        this.keyMarsh.writeObject(rec, asm);
        return new Row(this.schema, new ByteBufferRow(asm.toBytes()));
    }

    @Override
    @NotNull
    public R unmarshal(@NotNull Row row) throws MarshallerException {
        Object o = this.recMarsh.readObject(row);
        assert (this.recClass.isInstance(o));
        return (R)o;
    }

    private RowAssembler createAssembler(Object key, Object val) throws MarshallerException {
        ObjectStatistic keyStat = this.collectObjectStats(this.schema.keyColumns(), this.recMarsh, key);
        ObjectStatistic valStat = this.collectObjectStats(this.schema.valueColumns(), this.recMarsh, val);
        return new RowAssembler(this.schema, keyStat.nonNullColsSize, keyStat.nonNullCols, valStat.nonNullColsSize, valStat.nonNullCols);
    }

    private ObjectStatistic collectObjectStats(Columns cols, Marshaller marsh, Object obj) throws MarshallerException {
        if (obj == null || !cols.hasVarlengthColumns()) {
            return ObjectStatistic.ZERO_VARLEN_STATISTICS;
        }
        int cnt = 0;
        int size = 0;
        for (int i = cols.firstVarlengthColumn(); i < cols.length(); ++i) {
            Column column = cols.column(i);
            Object val = marsh.value(obj, column.schemaIndex());
            if (val == null || column.type().spec().fixedLength()) continue;
            size += MarshallerUtil.getValueSize(val, column.type());
            ++cnt;
        }
        return new ObjectStatistic(cnt, size);
    }

    private static class ObjectStatistic {
        static final ObjectStatistic ZERO_VARLEN_STATISTICS = new ObjectStatistic(0, 0);
        int nonNullCols;
        int nonNullColsSize;

        ObjectStatistic(int nonNullCols, int nonNullColsSize) {
            this.nonNullCols = nonNullCols;
            this.nonNullColsSize = nonNullColsSize;
        }
    }
}

