/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.TableFunctionScan;
import org.apache.ignite.internal.sql.engine.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractSetOpNode;
import org.apache.ignite.internal.sql.engine.exec.rel.CorrelatedNestedLoopJoinNode;
import org.apache.ignite.internal.sql.engine.exec.rel.FilterNode;
import org.apache.ignite.internal.sql.engine.exec.rel.HashAggregateNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Inbox;
import org.apache.ignite.internal.sql.engine.exec.rel.IndexScanNode;
import org.apache.ignite.internal.sql.engine.exec.rel.IndexSpoolNode;
import org.apache.ignite.internal.sql.engine.exec.rel.IntersectNode;
import org.apache.ignite.internal.sql.engine.exec.rel.LimitNode;
import org.apache.ignite.internal.sql.engine.exec.rel.MergeJoinNode;
import org.apache.ignite.internal.sql.engine.exec.rel.MinusNode;
import org.apache.ignite.internal.sql.engine.exec.rel.ModifyNode;
import org.apache.ignite.internal.sql.engine.exec.rel.NestedLoopJoinNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite.internal.sql.engine.exec.rel.ProjectNode;
import org.apache.ignite.internal.sql.engine.exec.rel.ScanNode;
import org.apache.ignite.internal.sql.engine.exec.rel.SortAggregateNode;
import org.apache.ignite.internal.sql.engine.exec.rel.SortNode;
import org.apache.ignite.internal.sql.engine.exec.rel.TableScanNode;
import org.apache.ignite.internal.sql.engine.exec.rel.TableSpoolNode;
import org.apache.ignite.internal.sql.engine.exec.rel.UnionAllNode;
import org.apache.ignite.internal.sql.engine.metadata.AffinityService;
import org.apache.ignite.internal.sql.engine.metadata.ColocationGroup;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteFilter;
import org.apache.ignite.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite.internal.sql.engine.rel.IgniteMergeJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteNestedLoopJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteProject;
import org.apache.ignite.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite.internal.sql.engine.rel.IgniteTableSpool;
import org.apache.ignite.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite.internal.sql.engine.rel.IgniteUnionAll;
import org.apache.ignite.internal.sql.engine.rel.IgniteValues;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteSingleHashAggregate;
import org.apache.ignite.internal.sql.engine.rel.agg.IgniteSingleSortAggregate;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite.internal.sql.engine.rule.LogicalScanConverterRule;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;
import org.apache.ignite.internal.sql.engine.trait.Destination;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;

public class LogicalRelImplementor<RowT>
implements IgniteRelVisitor<Node<RowT>> {
    public static final String CNLJ_NOT_SUPPORTED_JOIN_ASSERTION_MSG = "only INNER and LEFT join supported by IgniteCorrelatedNestedLoop";
    private final ExecutionContext<RowT> ctx;
    private final AffinityService affSrvc;
    private final ExchangeService exchangeSvc;
    private final MailboxRegistry mailboxRegistry;
    private final ExpressionFactory<RowT> expressionFactory;

    public LogicalRelImplementor(ExecutionContext<RowT> ctx, AffinityService affSrvc, MailboxRegistry mailboxRegistry, ExchangeService exchangeSvc) {
        this.affSrvc = affSrvc;
        this.mailboxRegistry = mailboxRegistry;
        this.exchangeSvc = exchangeSvc;
        this.ctx = ctx;
        this.expressionFactory = ctx.expressionFactory();
    }

    @Override
    public Node<RowT> visit(IgniteSender rel) {
        IgniteDistribution distribution = rel.distribution();
        Destination<RowT> dest = distribution.destination(this.ctx, this.affSrvc, this.ctx.target());
        Outbox<RowT> outbox = new Outbox<RowT>(this.ctx, rel.getRowType(), this.exchangeSvc, this.mailboxRegistry, rel.exchangeId(), rel.targetFragmentId(), dest);
        Node<RowT> input = this.visit(rel.getInput());
        outbox.register(input);
        this.mailboxRegistry.register(outbox);
        return outbox;
    }

    @Override
    public Node<RowT> visit(IgniteFilter rel) {
        Predicate<RowT> pred = this.expressionFactory.predicate(rel.getCondition(), rel.getRowType());
        FilterNode<RowT> node = new FilterNode<RowT>(this.ctx, rel.getRowType(), pred);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTrimExchange rel) {
        assert (TraitUtils.distribution((RelNode)rel).getType() == RelDistribution.Type.HASH_DISTRIBUTED);
        IgniteDistribution distr = rel.distribution();
        Destination dest = distr.destination(this.ctx, this.affSrvc, this.ctx.group(rel.sourceId()));
        String localNodeId = this.ctx.localNode().id();
        FilterNode<Object> node = new FilterNode<Object>(this.ctx, rel.getRowType(), r -> Objects.equals(localNodeId, CollectionUtils.first(dest.targets(r))));
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteProject rel) {
        Function<RowT, RowT> prj = this.expressionFactory.project(rel.getProjects(), rel.getInput().getRowType());
        ProjectNode<RowT> node = new ProjectNode<RowT>(this.ctx, rel.getRowType(), prj);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteNestedLoopJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
        BiPredicate<RowT, RowT> cond = this.expressionFactory.biPredicate(rel.getCondition(), rowType);
        NestedLoopJoinNode<RowT> node = NestedLoopJoinNode.create(this.ctx, outType, leftType, rightType, joinType, cond);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteCorrelatedNestedLoopJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
        BiPredicate<RowT, RowT> cond = this.expressionFactory.biPredicate(rel.getCondition(), rowType);
        assert (rel.getJoinType() == JoinRelType.INNER || rel.getJoinType() == JoinRelType.LEFT) : "only INNER and LEFT join supported by IgniteCorrelatedNestedLoop";
        CorrelatedNestedLoopJoinNode<RowT> node = new CorrelatedNestedLoopJoinNode<RowT>(this.ctx, outType, cond, rel.getVariablesSet(), rel.getJoinType());
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMergeJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        int pairsCnt = rel.analyzeCondition().pairs().size();
        Comparator<RowT> comp = this.expressionFactory.comparator(rel.leftCollation().getFieldCollations().subList(0, pairsCnt), rel.rightCollation().getFieldCollations().subList(0, pairsCnt));
        MergeJoinNode<RowT> node = MergeJoinNode.create(this.ctx, outType, leftType, rightType, joinType, comp);
        Node<RowT> leftInput = this.visit(rel.getLeft());
        Node<RowT> rightInput = this.visit(rel.getRight());
        node.register(ArrayUtils.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteIndexScan rel) {
        Comparator<RowT> comp;
        InternalIgniteTable tbl = (InternalIgniteTable)rel.getTable().unwrap(InternalIgniteTable.class);
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        ImmutableBitSet requiredColumns = rel.requiredColumns();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        IgniteIndex idx = tbl.getIndex(rel.indexName());
        List<SearchBounds> searchBounds = rel.searchBounds();
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        Predicate<RowT> filters = condition == null ? null : this.expressionFactory.predicate(condition, rowType);
        Function<RowT, RowT> prj = projects == null ? null : this.expressionFactory.project(projects, rowType);
        RangeIterable<RowT> ranges = searchBounds == null ? null : this.expressionFactory.ranges(searchBounds, rel.collation(), tbl.getRowType((RelDataTypeFactory)typeFactory));
        RelCollation outputCollation = rel.collation();
        if (projects != null || requiredColumns != null) {
            outputCollation = (RelCollation)outputCollation.apply(LogicalScanConverterRule.createMapping(projects, requiredColumns, tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount()));
        }
        ColocationGroup group = this.ctx.group(rel.sourceId());
        Comparator<RowT> comparator = comp = idx.type() == IgniteIndex.Type.SORTED ? this.ctx.expressionFactory().comparator(outputCollation) : null;
        if (!group.nodeIds().contains(this.ctx.localNode().id())) {
            return new ScanNode<RowT>(this.ctx, rowType, Collections.emptyList());
        }
        return new IndexScanNode<RowT>(this.ctx, rowType, idx, tbl, rel.collation().getKeys(), group.partitions(this.ctx.localNode().id()), comp, ranges, filters, prj, requiredColumns == null ? null : requiredColumns.toBitSet());
    }

    @Override
    public Node<RowT> visit(IgniteTableScan rel) {
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        ImmutableBitSet requiredColumns = rel.requiredColumns();
        InternalIgniteTable tbl = (InternalIgniteTable)rel.getTable().unwrap(InternalIgniteTable.class);
        assert (tbl != null);
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        Predicate<RowT> filters = condition == null ? null : this.expressionFactory.predicate(condition, rowType);
        Function<RowT, RowT> prj = projects == null ? null : this.expressionFactory.project(projects, rowType);
        ColocationGroup group = this.ctx.group(rel.sourceId());
        if (!group.nodeIds().contains(this.ctx.localNode().id())) {
            return new ScanNode<RowT>(this.ctx, rowType, Collections.emptyList());
        }
        return new TableScanNode<RowT>(this.ctx, rowType, tbl, group.partitions(this.ctx.localNode().id()), filters, prj, requiredColumns == null ? null : requiredColumns.toBitSet());
    }

    @Override
    public Node<RowT> visit(IgniteValues rel) {
        List vals = Commons.flat(Commons.cast(rel.getTuples()));
        RelDataType rowType = rel.getRowType();
        return new ScanNode<RowT>(this.ctx, rowType, this.expressionFactory.values(vals, rowType));
    }

    @Override
    public Node<RowT> visit(IgniteUnionAll rel) {
        UnionAllNode node = new UnionAllNode(this.ctx, rel.getRowType());
        List inputs = Commons.transform(rel.getInputs(), this::visit);
        node.register(inputs);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteLimit rel) {
        Supplier<Integer> offset = rel.offset() == null ? null : this.expressionFactory.execute(rel.offset());
        Supplier<Integer> fetch = rel.fetch() == null ? null : this.expressionFactory.execute(rel.fetch());
        LimitNode<RowT> node = new LimitNode<RowT>(this.ctx, rel.getRowType(), offset, fetch);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSort rel) {
        RelCollation collation = rel.getCollation();
        SortNode<RowT> node = new SortNode<RowT>(this.ctx, rel.getRowType(), this.expressionFactory.comparator(collation));
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTableSpool rel) {
        TableSpoolNode<RowT> node = new TableSpoolNode<RowT>(this.ctx, rel.getRowType(), rel.readType == Spool.Type.LAZY);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSortedIndexSpool rel) {
        RelCollation collation = rel.collation();
        assert (rel.searchBounds() != null) : rel;
        Predicate<RowT> filter = this.expressionFactory.predicate(rel.condition(), rel.getRowType());
        RangeIterable<RowT> ranges = this.expressionFactory.ranges(rel.searchBounds(), collation, rel.getRowType());
        IndexSpoolNode<RowT> node = IndexSpoolNode.createTreeSpool(this.ctx, rel.getRowType(), collation, this.expressionFactory.comparator(collation), filter, ranges);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteHashIndexSpool rel) {
        Supplier<RowT> searchRow = this.expressionFactory.rowSource(rel.searchRow());
        Predicate<RowT> filter = this.expressionFactory.predicate(rel.condition(), rel.getRowType());
        IndexSpoolNode<RowT> node = IndexSpoolNode.createHashSpool(this.ctx, rel.getRowType(), ImmutableBitSet.of((Iterable)rel.keys()), filter, searchRow);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSetOp rel) {
        AbstractSetOpNode node;
        RelDataType rowType = rel.getRowType();
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        List inputs = Commons.transform(rel.getInputs(), this::visit);
        if (rel instanceof Minus) {
            node = new MinusNode(this.ctx, rowType, rel.aggregateType(), rel.all(), rowFactory);
        } else if (rel instanceof Intersect) {
            node = new IntersectNode<RowT>(this.ctx, rowType, rel.aggregateType(), rel.all(), rowFactory, rel.getInputs().size());
        } else {
            throw new AssertionError();
        }
        node.register(inputs);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteTableFunctionScan rel) {
        Supplier<Iterable<Object[]>> dataSupplier = this.expressionFactory.execute(rel.getCall());
        RelDataType rowType = rel.getRowType();
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        return new ScanNode<RowT>(this.ctx, rowType, new TableFunctionScan<RowT>(dataSupplier, rowFactory));
    }

    @Override
    public Node<RowT> visit(IgniteTableModify rel) {
        switch (rel.getOperation()) {
            case INSERT: 
            case UPDATE: 
            case DELETE: 
            case MERGE: {
                InternalIgniteTable tbl = (InternalIgniteTable)rel.getTable().unwrap(InternalIgniteTable.class);
                assert (tbl != null);
                ModifyNode<RowT> node = new ModifyNode<RowT>(this.ctx, rel.getRowType(), tbl, rel.getOperation(), rel.getUpdateColumnList());
                Node<RowT> input = this.visit(rel.getInput());
                node.register(input);
                return node;
            }
        }
        throw new AssertionError((Object)("Unsupported operation: " + rel.getOperation()));
    }

    @Override
    public Node<RowT> visit(IgniteReceiver rel) {
        Inbox<RowT> inbox = this.mailboxRegistry.register(new Inbox<RowT>(this.ctx, this.exchangeSvc, this.mailboxRegistry, rel.exchangeId(), rel.sourceFragmentId()));
        inbox.init(this.ctx, rel.getRowType(), this.ctx.remotes(rel.exchangeId()), this.expressionFactory.comparator(rel.collation()));
        return inbox;
    }

    @Override
    public Node<RowT> visit(IgniteSingleHashAggregate rel) {
        AggregateType type = AggregateType.SINGLE;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        Supplier<List<AccumulatorWrapper<RowT>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType);
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, rowType, type, (List<ImmutableBitSet>)rel.getGroupSets(), accFactory, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMapHashAggregate rel) {
        AggregateType type = AggregateType.MAP;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        Supplier<List<AccumulatorWrapper<RowT>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType);
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, rowType, type, (List<ImmutableBitSet>)rel.getGroupSets(), accFactory, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteReduceHashAggregate rel) {
        AggregateType type = AggregateType.REDUCE;
        RelDataType rowType = rel.getRowType();
        Supplier<List<AccumulatorWrapper<RowT>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggregateCalls(), null);
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        HashAggregateNode<RowT> node = new HashAggregateNode<RowT>(this.ctx, rowType, type, rel.getGroupSets(), accFactory, rowFactory);
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteSingleSortAggregate rel) {
        AggregateType type = AggregateType.SINGLE;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        Supplier<List<AccumulatorWrapper<RowT>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType);
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, rowType, type, rel.getGroupSet(), accFactory, rowFactory, this.expressionFactory.comparator(rel.collation()));
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteMapSortAggregate rel) {
        AggregateType type = AggregateType.MAP;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        Supplier<List<AccumulatorWrapper<RowT>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType);
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, rowType, type, rel.getGroupSet(), accFactory, rowFactory, this.expressionFactory.comparator(rel.collation()));
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteReduceSortAggregate rel) {
        AggregateType type = AggregateType.REDUCE;
        RelDataType rowType = rel.getRowType();
        Supplier<List<AccumulatorWrapper<RowT>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggregateCalls(), null);
        RowHandler.RowFactory<RowT> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        SortAggregateNode<RowT> node = new SortAggregateNode<RowT>(this.ctx, rowType, type, rel.getGroupSet(), accFactory, rowFactory, this.expressionFactory.comparator(rel.collation()));
        Node<RowT> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<RowT> visit(IgniteRel rel) {
        return (Node)rel.accept(this);
    }

    @Override
    public Node<RowT> visit(IgniteExchange rel) {
        throw new AssertionError();
    }

    private Node<RowT> visit(RelNode rel) {
        return this.visit((IgniteRel)rel);
    }

    public <T extends Node<RowT>> T go(IgniteRel rel) {
        return (T)this.visit(rel);
    }
}

