/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class ScanNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT> {
    private final Iterable<RowT> src;
    private Iterator<RowT> it;
    private int requested;
    private boolean inLoop;

    public ScanNode(ExecutionContext<RowT> ctx, RelDataType rowType, Iterable<RowT> src) {
        super(ctx, rowType);
        this.src = src;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (rowsCnt > 0 && this.requested == 0) : "rowsCnt=" + rowsCnt + ", requested=" + this.requested;
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::push, this::onError);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        Commons.closeQuiet(this.it);
        this.it = null;
        Commons.closeQuiet(this.src);
    }

    @Override
    protected void rewindInternal() {
        Commons.closeQuiet(this.it);
        this.it = null;
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    private void push() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.checkState();
        this.inLoop = true;
        try {
            if (this.it == null) {
                this.it = this.src.iterator();
            }
            int processed = 0;
            while (this.requested > 0 && this.it.hasNext()) {
                this.checkState();
                --this.requested;
                this.downstream().push(this.it.next());
                if (++processed != 512 || this.requested <= 0) continue;
                this.context().execute(this::push, this::onError);
                return;
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested > 0 && !this.it.hasNext()) {
            Commons.closeQuiet(this.it);
            this.it = null;
            this.requested = 0;
            this.downstream().end();
        }
    }
}

