/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.sql.SqlColumnType;

public class SqlColumnTypeConverter {
    public static Class<?> columnTypeToClass(SqlColumnType type) {
        assert (type != null);
        switch (type) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case INT8: {
                return Byte.class;
            }
            case INT16: {
                return Short.class;
            }
            case INT32: {
                return Integer.class;
            }
            case INT64: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case NUMBER: {
                return BigInteger.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case UUID: {
                return UUID.class;
            }
            case STRING: {
                return String.class;
            }
            case BYTE_ARRAY: {
                return byte[].class;
            }
            case BITMASK: {
                return BitSet.class;
            }
            case DATE: {
                return LocalDate.class;
            }
            case TIME: {
                return LocalTime.class;
            }
            case DATETIME: {
                return LocalDateTime.class;
            }
            case TIMESTAMP: {
                return Instant.class;
            }
            case PERIOD: {
                return Period.class;
            }
            case DURATION: {
                return Duration.class;
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }
}

