/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.logger;

import java.io.PrintWriter;
import java.util.ResourceBundle;
import org.apache.ignite.internal.cli.logger.HttpLogging;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.LoggerFactory;
import org.apache.ignite.rest.client.invoker.Configuration;

public class CliLoggers {
    private static PrintWriter output;
    private static boolean isVerbose;
    private static final HttpLogging httpLogger;
    private static final LoggerFactory loggerFactory;

    public static IgniteLogger forClass(Class<?> cls) {
        return Loggers.forClass(cls, (LoggerFactory)loggerFactory);
    }

    public static IgniteLogger forName(String name) {
        return Loggers.forName((String)name, (LoggerFactory)loggerFactory);
    }

    public static void startOutputRedirect(PrintWriter out) {
        output = out;
        isVerbose = true;
        httpLogger.startHttpLogging(out);
    }

    public static void stopOutputRedirect() {
        output = null;
        isVerbose = false;
        httpLogger.stopHttpLogging();
    }

    public static boolean isVerbose() {
        return isVerbose;
    }

    static {
        httpLogger = new HttpLogging(Configuration.getDefaultApiClient());
        loggerFactory = name -> new CliLogger(System.getLogger(name));
    }

    private static class CliLogger
    implements System.Logger {
        private final System.Logger delegate;

        private CliLogger(System.Logger delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return this.delegate.isLoggable(level) || isVerbose;
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            if (isVerbose) {
                output.println(msg);
                output.println(thrown.getMessage());
            }
            this.delegate.log(level, bundle, msg, thrown);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            if (isVerbose) {
                output.println(format);
            }
            this.delegate.log(level, bundle, format, params);
        }
    }
}

