/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.visitor;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Import;
import io.micronaut.context.visitor.BeanImportHandler;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;

public class BeanImportVisitor
implements TypeElementVisitor<Import, Object> {
    private static final List<BeanImportHandler> BEAN_IMPORT_HANDLERS;

    @Override
    public void visitClass(ClassElement element, VisitorContext context) {
        List<ClassElement> beanElements = BeanImportVisitor.collectInjectableElements(element, context);
        for (ClassElement beanElement : beanElements) {
            BeanElementBuilder beanElementBuilder = element.addAssociatedBean(beanElement).inject();
            for (BeanImportHandler beanImportHandler : BEAN_IMPORT_HANDLERS) {
                beanImportHandler.beanAdded(beanElementBuilder, context);
            }
        }
    }

    @NonNull
    public static List<ClassElement> collectInjectableElements(ClassElement element, VisitorContext context) {
        Object[] packages;
        Object[] annotations;
        Set<Object> annotationSet;
        ArrayList<ClassElement> beanElements = new ArrayList<ClassElement>();
        Object[] classNames = element.getAnnotationMetadata().stringValues(Import.class, "classes");
        if (ArrayUtils.isNotEmpty((Object[])classNames)) {
            for (Object className : classNames) {
                context.getClassElement((String)className).ifPresent(beanElements::add);
            }
        }
        if (!(annotationSet = ArrayUtils.isEmpty((Object[])(annotations = element.getAnnotationMetadata().stringValues(Import.class, "annotated"))) ? CollectionUtils.setOf((Object[])new String[]{"javax.inject.Scope", Bean.class.getName(), "javax.inject.Qualifier"}) : new HashSet<Object>(Arrays.asList(annotations))).contains("*")) {
            for (BeanImportHandler beanImportHandler : BEAN_IMPORT_HANDLERS) {
                annotationSet.addAll(beanImportHandler.getSupportedAnnotationNames());
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])(packages = element.getAnnotationMetadata().stringValues(Import.class, "packages")))) {
            for (Object aPackage : packages) {
                ClassElement[] classElements;
                for (ClassElement classElement : classElements = context.getClassElements((String)aPackage, annotationSet.toArray(new String[0]))) {
                    if (classElement.isAbstract()) continue;
                    beanElements.add(classElement);
                }
            }
        }
        return beanElements;
    }

    @Override
    public Set<String> getSupportedAnnotationNames() {
        return Collections.singleton(Import.class.getName());
    }

    @Override
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static {
        ServiceLoader<BeanImportHandler> handlers = ServiceLoader.load(BeanImportHandler.class);
        ArrayList<BeanImportHandler> beanImportHandlers = new ArrayList<BeanImportHandler>();
        for (BeanImportHandler handler : handlers) {
            beanImportHandlers.add(handler);
        }
        OrderUtil.sort(beanImportHandlers);
        BEAN_IMPORT_HANDLERS = Collections.unmodifiableList(beanImportHandlers);
    }
}

