/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.raft.jraft.disruptor.DisruptorBuilder;
import org.apache.ignite.raft.jraft.disruptor.GroupAware;

public class StripedDisruptor<T extends GroupAware> {
    private static final IgniteLogger LOG = Loggers.forClass(StripedDisruptor.class);
    private final Disruptor<T>[] disruptors;
    private final RingBuffer<T>[] queues;
    private final ArrayList<StripeEntryHandler> eventHandlers;
    private final ArrayList<StripeExceptionHandler> exceptionHandlers;
    private final int stripes;
    private final String name;

    public StripedDisruptor(String name, int bufferSize, EventFactory<T> eventFactory, int stripes) {
        this.disruptors = new Disruptor[stripes];
        this.queues = new RingBuffer[stripes];
        this.eventHandlers = new ArrayList(stripes);
        this.exceptionHandlers = new ArrayList(stripes);
        this.stripes = stripes;
        this.name = name;
        for (int i = 0; i < stripes; ++i) {
            String stripeName = IgniteStringFormatter.format((String)"{}_stripe_{}-", (Object[])new Object[]{name, i});
            Disruptor disruptor = DisruptorBuilder.newInstance().setRingBufferSize(bufferSize).setEventFactory(eventFactory).setThreadFactory((ThreadFactory)new NamedThreadFactory(stripeName, true, LOG)).setProducerType(ProducerType.MULTI).setWaitStrategy((WaitStrategy)new BlockingWaitStrategy()).build();
            this.eventHandlers.add(new StripeEntryHandler());
            this.exceptionHandlers.add(new StripeExceptionHandler(name));
            disruptor.handleEventsWith(new EventHandler[]{this.eventHandlers.get(i)});
            disruptor.setDefaultExceptionHandler((ExceptionHandler)this.exceptionHandlers.get(i));
            this.queues[i] = disruptor.start();
            this.disruptors[i] = disruptor;
        }
    }

    public void shutdown() {
        for (int i = 0; i < this.stripes; ++i) {
            if (this.disruptors[i] != null) {
                this.disruptors[i].shutdown();
            }
            this.queues[i] = null;
            this.disruptors[i] = null;
        }
        this.eventHandlers.clear();
        this.exceptionHandlers.clear();
    }

    public RingBuffer<T> subscribe(String group, EventHandler<T> handler) {
        return this.subscribe(group, handler, null);
    }

    public RingBuffer<T> subscribe(String group, EventHandler<T> handler, BiConsumer<T, Throwable> exceptionHandler) {
        this.eventHandlers.get(this.getStripe(group)).subscribe(group, handler);
        if (exceptionHandler != null) {
            this.exceptionHandlers.get(this.getStripe(group)).subscribe(group, exceptionHandler);
        }
        return this.queues[this.getStripe(group)];
    }

    public void unsubscribe(String group) {
        this.eventHandlers.get(this.getStripe(group)).unsubscribe(group);
        this.exceptionHandlers.get(this.getStripe(group)).unsubscribe(group);
    }

    private int getStripe(String group) {
        return Math.abs(group.hashCode() % this.stripes);
    }

    public RingBuffer<T> queue(String groupId) {
        return this.queues[this.getStripe(groupId)];
    }

    public String toString() {
        return IgniteStringFormatter.format((String)"{} [name={}]", (Object[])new Object[]{StripedDisruptor.class.getSimpleName(), this.name});
    }

    private class StripeExceptionHandler
    implements ExceptionHandler<T> {
        private final String name;
        private final ConcurrentHashMap<String, BiConsumer<T, Throwable>> subscribers;

        StripeExceptionHandler(String name) {
            this.name = name;
            this.subscribers = new ConcurrentHashMap();
        }

        void subscribe(String group, BiConsumer<T, Throwable> handler) {
            this.subscribers.put(group, handler);
        }

        void unsubscribe(String group) {
            this.subscribers.remove(group);
        }

        public void handleOnStartException(Throwable ex) {
            LOG.error("Fail to start disruptor [name={}]", ex, new Object[]{this.name});
        }

        public void handleOnShutdownException(Throwable ex) {
            LOG.error("Fail to shutdown disruptor [name={}]", ex, new Object[]{this.name});
        }

        public void handleEventException(Throwable ex, long sequence, T event) {
            BiConsumer handler = this.subscribers.get(event.groupId());
            LOG.error("Handle disruptor event error [name={}, event={}, hasHandler={}]", ex, new Object[]{this.name, event, handler != null});
            if (handler != null) {
                handler.accept(event, ex);
            }
        }
    }

    private class StripeEntryHandler
    implements EventHandler<T> {
        private final ConcurrentHashMap<String, EventHandler<T>> subscribers = new ConcurrentHashMap();

        StripeEntryHandler() {
        }

        void subscribe(String group, EventHandler<T> handler) {
            this.subscribers.put(group, handler);
        }

        void unsubscribe(String group) {
            this.subscribers.remove(group);
        }

        public void onEvent(T event, long sequence, boolean endOfBatch) throws Exception {
            EventHandler handler = this.subscribers.get(event.groupId());
            assert (handler != null) : IgniteStringFormatter.format((String)"Group of the event is unsupported [group={}, event={}]", (Object[])new Object[]{event.groupId(), event});
            handler.onEvent(event, sequence, true);
        }
    }
}

