/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.storage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorageListener;
import org.apache.ignite.internal.configuration.storage.Data;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.apache.ignite.internal.configuration.util.ConfigurationSerializationUtil;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.client.Condition;
import org.apache.ignite.internal.metastorage.client.Conditions;
import org.apache.ignite.internal.metastorage.client.Entry;
import org.apache.ignite.internal.metastorage.client.EntryEvent;
import org.apache.ignite.internal.metastorage.client.Operation;
import org.apache.ignite.internal.metastorage.client.Operations;
import org.apache.ignite.internal.metastorage.client.SimpleCondition;
import org.apache.ignite.internal.metastorage.client.WatchEvent;
import org.apache.ignite.internal.metastorage.client.WatchListener;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.vault.VaultEntry;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.lang.ByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistributedConfigurationStorage
implements ConfigurationStorage {
    private static final IgniteLogger LOG = Loggers.forClass(DistributedConfigurationStorage.class);
    private static final String DISTRIBUTED_PREFIX = "dst-cfg.";
    private static final ByteArray MASTER_KEY = new ByteArray("dst-cfg.$master$key");
    private static final ByteArray CONFIGURATION_REVISIONS_KEY = new ByteArray("$revisions");
    private static final ByteArray DST_KEYS_START_RANGE = new ByteArray("dst-cfg.");
    private static final ByteArray DST_KEYS_END_RANGE = new ByteArray(DistributedConfigurationStorage.incrementLastChar("dst-cfg."));
    private final MetaStorageManager metaStorageMgr;
    private final VaultManager vaultMgr;
    private volatile ConfigurationStorageListener lsnr;
    private final AtomicLong changeId = new AtomicLong(0L);
    private final ExecutorService threadPool = Executors.newFixedThreadPool(4, (ThreadFactory)new NamedThreadFactory("dst-cfg", LOG));
    private final InFlightFutures futureTracker = new InFlightFutures();

    public DistributedConfigurationStorage(MetaStorageManager metaStorageMgr, VaultManager vaultMgr) {
        this.metaStorageMgr = metaStorageMgr;
        this.vaultMgr = vaultMgr;
    }

    public void close() throws Exception {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        this.futureTracker.cancelInFlightFutures();
    }

    public CompletableFuture<Map<String, ? extends Serializable>> readAllLatest(String prefix) {
        return this.registerFuture(CompletableFuture.supplyAsync(() -> {
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            ByteArray rangeStart = new ByteArray(DISTRIBUTED_PREFIX + prefix);
            ByteArray rangeEnd = new ByteArray(DistributedConfigurationStorage.incrementLastChar(DISTRIBUTED_PREFIX + prefix));
            try (Cursor entries = this.metaStorageMgr.range(rangeStart, rangeEnd);){
                for (Entry entry : entries) {
                    ByteArray key = entry.key();
                    byte[] value = entry.value();
                    if (entry.tombstone()) continue;
                    assert (value != null);
                    if (key.equals((Object)MASTER_KEY)) continue;
                    String dataKey = key.toString().substring(DISTRIBUTED_PREFIX.length());
                    data.put(dataKey, ConfigurationSerializationUtil.fromBytes((byte[])value));
                }
            }
            catch (Exception e) {
                throw new StorageException("Exception when closing a Meta Storage cursor", (Throwable)e);
            }
            return data;
        }, this.threadPool));
    }

    public CompletableFuture<Serializable> readLatest(String key) {
        return ((CompletableFuture)this.metaStorageMgr.get(new ByteArray(DISTRIBUTED_PREFIX + key)).thenApply(entry -> {
            byte[] value = entry.value();
            return value == null ? null : ConfigurationSerializationUtil.fromBytes((byte[])value);
        })).exceptionally(e -> {
            throw new StorageException("Exception while reading data from Meta Storage", e);
        });
    }

    public CompletableFuture<Data> readDataOnRecovery() throws StorageException {
        CompletionStage future = ((CompletableFuture)this.vaultMgr.get(MetaStorageManager.APPLIED_REV).thenCombine((CompletionStage)this.vaultMgr.get(CONFIGURATION_REVISIONS_KEY), this::resolveRevision)).thenApplyAsync(this::readDataOnRecovery0, (Executor)this.threadPool);
        return this.registerFuture((CompletableFuture)future);
    }

    private long resolveRevision(@Nullable VaultEntry appliedRevEntry, @Nullable VaultEntry revisionsEntry) {
        long appliedRevision;
        long cfgRevision = appliedRevision = appliedRevEntry == null ? 0L : ByteUtils.bytesToLong((byte[])appliedRevEntry.value());
        if (revisionsEntry != null) {
            byte[] value = revisionsEntry.value();
            long prevMasterKeyRevision = ByteUtils.bytesToLong((byte[])value, (int)0);
            long curMasterKeyRevision = ByteUtils.bytesToLong((byte[])value, (int)8);
            cfgRevision = curMasterKeyRevision <= appliedRevision ? curMasterKeyRevision : prevMasterKeyRevision;
        }
        return cfgRevision;
    }

    private Data readDataOnRecovery0(long cfgRevision) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        try (Cursor<VaultEntry> entries = this.storedDistributedConfigKeys();){
            for (VaultEntry entry : entries) {
                ByteArray key = entry.key();
                byte[] value = entry.value();
                assert (value != null);
                if (key.equals((Object)MASTER_KEY)) continue;
                String dataKey = key.toString().substring(DISTRIBUTED_PREFIX.length());
                data.put(dataKey, ConfigurationSerializationUtil.fromBytes((byte[])value));
            }
        }
        catch (Exception e) {
            throw new StorageException("Exception when closing a Vault cursor", (Throwable)e);
        }
        assert (data.isEmpty() || cfgRevision > 0L);
        this.changeId.set(data.isEmpty() ? 0L : cfgRevision);
        return new Data(data, cfgRevision);
    }

    public CompletableFuture<Boolean> write(Map<String, ? extends Serializable> newValues, long curChangeId) {
        assert (curChangeId <= this.changeId.get());
        assert (this.lsnr != null) : "Configuration listener must be initialized before write.";
        if (curChangeId < this.changeId.get()) {
            return CompletableFuture.completedFuture(false);
        }
        HashSet<Operation> operations = new HashSet<Operation>();
        for (Map.Entry<String, ? extends Serializable> entry : newValues.entrySet()) {
            ByteArray key = new ByteArray(DISTRIBUTED_PREFIX + entry.getKey());
            if (entry.getValue() != null) {
                operations.add(Operations.put((ByteArray)key, (byte[])ConfigurationSerializationUtil.toBytes((Object)entry.getValue())));
                continue;
            }
            operations.add(Operations.remove((ByteArray)key));
        }
        operations.add(Operations.put((ByteArray)MASTER_KEY, (byte[])ByteUtils.longToBytes((long)curChangeId)));
        SimpleCondition condition = curChangeId == 0L ? Conditions.notExists((ByteArray)MASTER_KEY) : Conditions.revision((ByteArray)MASTER_KEY).eq(curChangeId);
        return this.metaStorageMgr.invoke((Condition)condition, operations, Set.of(Operations.noop()));
    }

    public synchronized void registerConfigurationListener(final @NotNull ConfigurationStorageListener lsnr) {
        if (this.lsnr == null) {
            this.lsnr = lsnr;
            this.metaStorageMgr.registerWatchByPrefix(DST_KEYS_START_RANGE, new WatchListener(){

                public boolean onUpdate(@NotNull WatchEvent events) {
                    HashMap<String, Serializable> data = new HashMap<String, Serializable>();
                    Entry masterKeyEntry = null;
                    for (EntryEvent event : events.entryEvents()) {
                        Entry e = event.newEntry();
                        if (e.key().equals((Object)MASTER_KEY)) {
                            masterKeyEntry = e;
                            continue;
                        }
                        String key = e.key().toString().substring(DistributedConfigurationStorage.DISTRIBUTED_PREFIX.length());
                        Serializable value = e.value() == null ? null : ConfigurationSerializationUtil.fromBytes((byte[])e.value());
                        data.put(key, value);
                    }
                    assert (masterKeyEntry != null);
                    long newChangeId = masterKeyEntry.revision();
                    assert (newChangeId > DistributedConfigurationStorage.this.changeId.get());
                    DistributedConfigurationStorage.this.changeId.set(newChangeId);
                    lsnr.onEntriesChanged(new Data(data, newChangeId)).join();
                    return true;
                }

                public void onError(@NotNull Throwable e) {
                    LOG.warn("Meta storage listener issue", e);
                }
            });
        } else {
            LOG.info("Configuration listener has already been set", new Object[0]);
        }
    }

    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    public CompletableFuture<Long> lastRevision() {
        return this.metaStorageMgr.get(MASTER_KEY).thenApply(Entry::revision);
    }

    public CompletableFuture<Void> writeConfigurationRevision(long prevRevision, long currentRevision) {
        byte[] value = new byte[16];
        ByteUtils.putLongToBytes((long)prevRevision, (byte[])value, (int)0);
        ByteUtils.putLongToBytes((long)currentRevision, (byte[])value, (int)8);
        return this.vaultMgr.put(CONFIGURATION_REVISIONS_KEY, value);
    }

    private Cursor<VaultEntry> storedDistributedConfigKeys() {
        return this.vaultMgr.range(DST_KEYS_START_RANGE, DST_KEYS_END_RANGE);
    }

    private static String incrementLastChar(String str) {
        char lastChar = str.charAt(str.length() - 1);
        return str.substring(0, str.length() - 1) + (char)(lastChar + '\u0001');
    }

    private <T> CompletableFuture<T> registerFuture(CompletableFuture<T> future) {
        this.futureTracker.registerFuture(future);
        return future;
    }
}

