/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.client.handler.ClientInboundMessageHandler;
import org.apache.ignite.client.handler.configuration.ClientConnectorConfiguration;
import org.apache.ignite.client.handler.configuration.ClientConnectorView;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.client.proto.ClientMessageDecoder;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NettyBootstrapFactory;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.tx.IgniteTransactions;

public class ClientHandlerModule
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(ClientHandlerModule.class);
    private final ConfigurationRegistry registry;
    private final IgniteTablesInternal igniteTables;
    private final IgniteTransactions igniteTransactions;
    private final IgniteSql sql;
    private volatile Channel channel;
    private final QueryProcessor queryProcessor;
    private final IgniteCompute igniteCompute;
    private final ClusterService clusterService;
    private final NettyBootstrapFactory bootstrapFactory;

    public ClientHandlerModule(QueryProcessor queryProcessor, IgniteTablesInternal igniteTables, IgniteTransactions igniteTransactions, ConfigurationRegistry registry, IgniteCompute igniteCompute, ClusterService clusterService, NettyBootstrapFactory bootstrapFactory, IgniteSql sql) {
        assert (igniteTables != null);
        assert (registry != null);
        assert (queryProcessor != null);
        assert (igniteCompute != null);
        assert (clusterService != null);
        assert (bootstrapFactory != null);
        assert (sql != null);
        this.queryProcessor = queryProcessor;
        this.igniteTables = igniteTables;
        this.igniteTransactions = igniteTransactions;
        this.igniteCompute = igniteCompute;
        this.clusterService = clusterService;
        this.registry = registry;
        this.bootstrapFactory = bootstrapFactory;
        this.sql = sql;
    }

    public void start() {
        if (this.channel != null) {
            throw new IgniteException("ClientHandlerModule is already started.");
        }
        try {
            this.channel = this.startEndpoint().channel();
        }
        catch (InterruptedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public void stop() throws Exception {
        if (this.channel != null) {
            this.channel.close().await();
            this.channel = null;
        }
    }

    public InetSocketAddress localAddress() {
        if (this.channel == null) {
            throw new IgniteInternalException("ClientHandlerModule has not been started");
        }
        return (InetSocketAddress)this.channel.localAddress();
    }

    private ChannelFuture startEndpoint() throws InterruptedException {
        final ClientConnectorView configuration = (ClientConnectorView)((ClientConnectorConfiguration)this.registry.getConfiguration(ClientConnectorConfiguration.KEY)).value();
        int desiredPort = configuration.port();
        int portRange = configuration.portRange();
        int port = 0;
        Channel ch = null;
        ServerBootstrap bootstrap = this.bootstrapFactory.createServerBootstrap();
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                if (configuration.idleTimeout() > 0L) {
                    IdleStateHandler idleStateHandler = new IdleStateHandler(configuration.idleTimeout(), 0L, 0L, TimeUnit.MILLISECONDS);
                    ch.pipeline().addLast(new ChannelHandler[]{idleStateHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleChannelHandler()});
                }
                ch.pipeline().addLast(new ChannelHandler[]{new ClientMessageDecoder(), new ClientInboundMessageHandler(ClientHandlerModule.this.igniteTables, ClientHandlerModule.this.igniteTransactions, ClientHandlerModule.this.queryProcessor, configuration, ClientHandlerModule.this.igniteCompute, ClientHandlerModule.this.clusterService, ClientHandlerModule.this.sql)});
            }
        }).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)configuration.connectTimeout());
        for (int portCandidate = desiredPort; portCandidate <= desiredPort + portRange; ++portCandidate) {
            ChannelFuture bindRes = bootstrap.bind(portCandidate).await();
            if (bindRes.isSuccess()) {
                ch = bindRes.channel();
                port = portCandidate;
                break;
            }
            if (bindRes.cause() instanceof BindException) continue;
            throw new IgniteException(bindRes.cause());
        }
        if (ch == null) {
            String msg = "Cannot start thin client connector endpoint. All ports are in use [ports=[" + desiredPort + ", " + (desiredPort + portRange) + "]]";
            LOG.debug(msg, new Object[0]);
            throw new IgniteException(msg);
        }
        LOG.info("Thin client protocol started successfully[port={}]", new Object[]{port});
        return ch.closeFuture();
    }

    private static class IdleChannelHandler
    extends ChannelDuplexHandler {
        private IdleChannelHandler() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                ctx.close();
            }
        }
    }
}

