/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageBuilder;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class HandshakeStartResponseMessageDeserializer
implements MessageDeserializer<HandshakeStartResponseMessage> {
    private final HandshakeStartResponseMessageBuilder msg;

    HandshakeStartResponseMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeStartResponseMessage();
    }

    public Class<HandshakeStartResponseMessage> klass() {
        return HandshakeStartResponseMessage.class;
    }

    public HandshakeStartResponseMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.connectionId(reader.readShort("connectionId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.consistentId(reader.readString("consistentId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.launchId(reader.readUuid("launchId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.receivedCount(reader.readLong("receivedCount"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeStartResponseMessage.class);
    }
}

