/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.ignite.internal.schema.BinaryRow;

public class ByteBufferRow
implements BinaryRow {
    public static final ByteOrder ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ByteBuffer buf;

    public ByteBufferRow(byte[] data) {
        this(ByteBuffer.wrap(data).order(ORDER));
    }

    public ByteBufferRow(ByteBuffer buf) {
        assert (buf.order() == ORDER);
        assert (buf.position() == 0);
        this.buf = buf;
    }

    @Override
    public int schemaVersion() {
        return Short.toUnsignedInt(this.buf.getShort(0));
    }

    @Override
    public boolean hasValue() {
        short schemaVer = this.buf.getShort(0);
        return schemaVer > 0;
    }

    @Override
    public int hash() {
        return this.buf.getInt(2);
    }

    @Override
    public void writeTo(OutputStream stream) throws IOException {
        WritableByteChannel channel = Channels.newChannel(stream);
        channel.write(this.buf);
        this.buf.rewind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer keySlice() {
        int off = 6;
        int len = this.buf.getInt(off);
        int limit = this.buf.limit();
        try {
            ByteBuffer byteBuffer = this.buf.limit(off + len).position(off).slice().order(ORDER);
            return byteBuffer;
        }
        finally {
            this.buf.position(0);
            this.buf.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer valueSlice() {
        int off = 6 + this.buf.getInt(6);
        int len = this.hasValue() ? this.buf.getInt(off) : 0;
        int limit = this.buf.limit();
        try {
            ByteBuffer byteBuffer = this.buf.limit(off + len).position(off).slice().order(ORDER);
            return byteBuffer;
        }
        finally {
            this.buf.position(0);
            this.buf.limit(limit);
        }
    }

    @Override
    public byte[] bytes() {
        byte[] tmp = new byte[this.buf.limit()];
        this.buf.get(tmp);
        this.buf.rewind();
        return tmp;
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.buf.slice().order(ORDER);
    }
}

