/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.watch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.ignite.internal.metastorage.client.EntryEvent;
import org.apache.ignite.internal.metastorage.client.WatchEvent;
import org.apache.ignite.internal.metastorage.client.WatchListener;
import org.apache.ignite.internal.metastorage.watch.AggregatedWatch;
import org.apache.ignite.internal.metastorage.watch.KeyCriterion;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.NotNull;

public class WatchAggregator {
    private final Map<Long, Watch> watches = Collections.synchronizedMap(new LinkedHashMap());
    private final AtomicLong idCntr = new AtomicLong(0L);

    public long add(ByteArray key, WatchListener lsnr) {
        Watch watch = new Watch(new KeyCriterion.ExactCriterion(key), lsnr);
        long id = this.idCntr.incrementAndGet();
        this.watches.put(id, watch);
        return id;
    }

    public long add(Collection<ByteArray> keys, WatchListener lsnr) {
        Watch watch = new Watch(new KeyCriterion.CollectionCriterion(keys), lsnr);
        long id = this.idCntr.incrementAndGet();
        this.watches.put(id, watch);
        return id;
    }

    public long add(ByteArray from, ByteArray to, WatchListener lsnr) {
        Watch watch = new Watch(new KeyCriterion.RangeCriterion(from, to), lsnr);
        long id = this.idCntr.incrementAndGet();
        this.watches.put(id, watch);
        return id;
    }

    public long addPrefix(ByteArray key, WatchListener lsnr) {
        Watch watch = new Watch(KeyCriterion.RangeCriterion.fromPrefixKey(key), lsnr);
        long id = this.idCntr.incrementAndGet();
        this.watches.put(id, watch);
        return id;
    }

    public void cancel(long id) {
        this.watches.remove(id);
    }

    public void cancelAll(Collection<Long> ids) {
        this.watches.keySet().removeAll(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<AggregatedWatch> watch(long revision, BiConsumer<Collection<IgniteBiTuple<ByteArray, byte[]>>, Long> saveRevisionAct) {
        Map<Long, Watch> map = this.watches;
        synchronized (map) {
            if (this.watches.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new AggregatedWatch(this.inferGeneralCriteria(), revision, this.watchListener(saveRevisionAct)));
        }
    }

    private KeyCriterion inferGeneralCriteria() {
        return this.watches.values().stream().map(Watch::keyCriterion).reduce(KeyCriterion::union).get();
    }

    private WatchListener watchListener(final BiConsumer<Collection<IgniteBiTuple<ByteArray, byte[]>>, Long> storeRevision) {
        final LinkedHashMap<Long, Watch> cpWatches = new LinkedHashMap<Long, Watch>(this.watches);
        return new WatchListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onUpdate(@NotNull WatchEvent evt) {
                Map<Long, Watch> map = WatchAggregator.this.watches;
                synchronized (map) {
                    this.processWatchEvents(evt);
                }
                return true;
            }

            private void processWatchEvents(@NotNull WatchEvent evt) {
                Iterator watchIt = cpWatches.entrySet().iterator();
                ArrayList<Long> toCancel = new ArrayList<Long>();
                while (watchIt.hasNext()) {
                    Map.Entry entry = watchIt.next();
                    Watch watch = (Watch)entry.getValue();
                    ArrayList<EntryEvent> filteredEvts = new ArrayList<EntryEvent>();
                    for (EntryEvent entryEvt : evt.entryEvents()) {
                        if (!watch.keyCriterion().contains(entryEvt.oldEntry().key())) continue;
                        filteredEvts.add(entryEvt);
                    }
                    if (filteredEvts.isEmpty() || watch.listener().onUpdate(new WatchEvent(filteredEvts))) continue;
                    watchIt.remove();
                    toCancel.add((Long)entry.getKey());
                }
                if (!toCancel.isEmpty()) {
                    WatchAggregator.this.cancelAll(toCancel);
                }
                long revision = 0L;
                ArrayList<IgniteBiTuple> entries = new ArrayList<IgniteBiTuple>();
                for (EntryEvent entryEvt : evt.entryEvents()) {
                    revision = entryEvt.newEntry().revision();
                    entries.add(new IgniteBiTuple((Object)entryEvt.newEntry().key(), (Object)entryEvt.newEntry().value()));
                }
                storeRevision.accept(entries, revision);
            }

            public void onError(@NotNull Throwable e) {
                WatchAggregator.this.watches.values().forEach(w -> w.listener().onError(e));
            }
        };
    }

    private static class Watch {
        private final KeyCriterion keyCriterion;
        private final WatchListener lsnr;

        private Watch(KeyCriterion keyCriterion, WatchListener lsnr) {
            this.keyCriterion = keyCriterion;
            this.lsnr = lsnr;
        }

        public KeyCriterion keyCriterion() {
            return this.keyCriterion;
        }

        public WatchListener listener() {
            return this.lsnr;
        }
    }
}

