/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.rocksdb.ColumnFamily;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.index.SortedIndexDescriptor;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.storage.rocksdb.RocksDbMvPartitionStorage;
import org.apache.ignite.internal.storage.rocksdb.index.RocksDbSortedIndexStorage;
import org.rocksdb.RocksDBException;

class SortedIndex
implements AutoCloseable {
    private final SortedIndexDescriptor descriptor;
    private final ColumnFamily indexCf;
    private final ConcurrentMap<Integer, SortedIndexStorage> storages = new ConcurrentHashMap<Integer, SortedIndexStorage>();

    SortedIndex(ColumnFamily indexCf, SortedIndexDescriptor descriptor) {
        this.descriptor = descriptor;
        this.indexCf = indexCf;
    }

    SortedIndexStorage getOrCreateStorage(RocksDbMvPartitionStorage partitionStorage) {
        return this.storages.computeIfAbsent(partitionStorage.partitionId(), partId -> new RocksDbSortedIndexStorage(this.descriptor, this.indexCf, partitionStorage));
    }

    ColumnFamily indexCf() {
        return this.indexCf;
    }

    void destroy() {
        try {
            this.indexCf.destroy();
        }
        catch (RocksDBException e) {
            throw new StorageException("Unable to destroy index " + this.descriptor.id(), (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.indexCf.handle().close();
    }
}

