/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.Classes;
import org.apache.ignite.internal.network.serialization.ReflectionException;
import org.apache.ignite.internal.network.serialization.SpecialMethodInvocationException;
import org.apache.ignite.internal.network.serialization.SpecialSerializationMethods;
import org.jetbrains.annotations.Nullable;

class SpecialSerializationMethodsImpl
implements SpecialSerializationMethods {
    @Nullable
    private final Method writeReplace;
    @Nullable
    private final Method readResolve;
    @Nullable
    private final Method writeObject;
    @Nullable
    private final Method readObject;

    public SpecialSerializationMethodsImpl(ClassDescriptor descriptor) {
        this.writeReplace = descriptor.hasWriteReplace() ? SpecialSerializationMethodsImpl.writeReplaceInvoker(descriptor) : null;
        this.readResolve = descriptor.hasReadResolve() ? SpecialSerializationMethodsImpl.readResolveInvoker(descriptor) : null;
        this.writeObject = descriptor.hasWriteObject() ? SpecialSerializationMethodsImpl.writeObjectInvoker(descriptor) : null;
        this.readObject = descriptor.hasReadObject() ? SpecialSerializationMethodsImpl.readObjectInvoker(descriptor) : null;
    }

    private static Method writeReplaceInvoker(ClassDescriptor descriptor) {
        Method method = Classes.getWriteReplace(descriptor.localClass());
        if (method == null) {
            throw new ReflectionException("Cannot find writeReplace() in " + String.valueOf(descriptor.localClass()), null);
        }
        method.setAccessible(true);
        return method;
    }

    private static Method readResolveInvoker(ClassDescriptor descriptor) {
        Method method = Classes.getReadResolve(descriptor.localClass());
        if (method == null) {
            throw new ReflectionException("Cannot find readResolve() in " + String.valueOf(descriptor.localClass()), null);
        }
        method.setAccessible(true);
        return method;
    }

    private static Method writeObjectInvoker(ClassDescriptor descriptor) {
        try {
            Method method = descriptor.localClass().getDeclaredMethod("writeObject", ObjectOutputStream.class);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException("Cannot find writeObject() in " + String.valueOf(descriptor.localClass()), e);
        }
    }

    private static Method readObjectInvoker(ClassDescriptor descriptor) {
        try {
            Method method = descriptor.localClass().getDeclaredMethod("readObject", ObjectInputStream.class);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException("Cannot find readObject() in " + String.valueOf(descriptor.localClass()), e);
        }
    }

    @Override
    public Object writeReplace(Object object) throws SpecialMethodInvocationException {
        Objects.requireNonNull(this.writeReplace);
        try {
            return this.writeReplace.invoke(object, (Object[])null);
        }
        catch (ReflectiveOperationException e) {
            throw new SpecialMethodInvocationException("writeReplace() invocation failed on " + String.valueOf(object), e);
        }
    }

    @Override
    public Object readResolve(Object object) throws SpecialMethodInvocationException {
        Objects.requireNonNull(this.readResolve);
        try {
            return this.readResolve.invoke(object, (Object[])null);
        }
        catch (ReflectiveOperationException e) {
            throw new SpecialMethodInvocationException("readResolve() invocation failed on " + String.valueOf(object), e);
        }
    }

    @Override
    public void writeObject(Object object, ObjectOutputStream stream) throws SpecialMethodInvocationException {
        Objects.requireNonNull(this.writeObject);
        try {
            this.writeObject.invoke(object, stream);
        }
        catch (ReflectiveOperationException e) {
            throw new SpecialMethodInvocationException("writeObject() invocation failed on " + String.valueOf(object), e);
        }
    }

    @Override
    public void readObject(Object object, ObjectInputStream stream) throws SpecialMethodInvocationException {
        Objects.requireNonNull(this.readObject);
        try {
            this.readObject.invoke(object, stream);
        }
        catch (ReflectiveOperationException e) {
            throw new SpecialMethodInvocationException("readObject() invocation failed on " + String.valueOf(object), e);
        }
    }
}

