/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.UpdateLogEvent;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.jetbrains.annotations.Nullable;

public class SnapshotEntry
implements UpdateLogEvent {
    public static final CatalogObjectSerializer<SnapshotEntry> SERIALIZER = new SnapshotEntrySerializer();
    private final int version;
    private final long activationTime;
    private final int objectIdGenState;
    private final CatalogZoneDescriptor[] zones;
    private final CatalogSchemaDescriptor[] schemas;
    @Nullable
    private final Integer defaultZoneId;

    public SnapshotEntry(Catalog catalog) {
        this(catalog.version(), catalog.time(), catalog.objectIdGenState(), (CatalogZoneDescriptor[])catalog.zones().toArray(CatalogZoneDescriptor[]::new), (CatalogSchemaDescriptor[])catalog.schemas().toArray(CatalogSchemaDescriptor[]::new), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    private SnapshotEntry(int version, long activationTime, int objectIdGenState, CatalogZoneDescriptor[] zones, CatalogSchemaDescriptor[] schemas, @Nullable Integer defaultZoneId) {
        this.version = version;
        this.activationTime = activationTime;
        this.objectIdGenState = objectIdGenState;
        this.zones = zones;
        this.schemas = schemas;
        this.defaultZoneId = defaultZoneId;
    }

    public int version() {
        return this.version;
    }

    public Catalog snapshot() {
        return new Catalog(this.version, this.activationTime, this.objectIdGenState, List.of(this.zones), List.of(this.schemas), this.defaultZoneId);
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.SNAPSHOT.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotEntry that = (SnapshotEntry)o;
        return this.version == that.version && this.activationTime == that.activationTime && this.objectIdGenState == that.objectIdGenState && Arrays.equals(this.zones, that.zones) && Arrays.equals(this.schemas, that.schemas);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class SnapshotEntrySerializer
    implements CatalogObjectSerializer<SnapshotEntry> {
        private SnapshotEntrySerializer() {
        }

        @Override
        public SnapshotEntry readFrom(IgniteDataInput input) throws IOException {
            int catalogVersion = input.readVarIntAsInt();
            long activationTime = input.readLong();
            int objectIdGenState = input.readVarIntAsInt();
            CatalogZoneDescriptor[] zones = CatalogSerializationUtils.readArray(CatalogZoneDescriptor.SERIALIZER, input, CatalogZoneDescriptor.class);
            CatalogSchemaDescriptor[] schemas = CatalogSerializationUtils.readArray(CatalogSchemaDescriptor.SERIALIZER, input, CatalogSchemaDescriptor.class);
            Integer defaultZoneId = null;
            if (input.readBoolean()) {
                defaultZoneId = input.readVarIntAsInt();
            }
            return new SnapshotEntry(catalogVersion, activationTime, objectIdGenState, zones, schemas, defaultZoneId);
        }

        @Override
        public void writeTo(SnapshotEntry entry, IgniteDataOutput output) throws IOException {
            output.writeVarInt((long)entry.version);
            output.writeLong(entry.activationTime);
            output.writeVarInt((long)entry.objectIdGenState);
            CatalogSerializationUtils.writeArray(entry.zones, CatalogZoneDescriptor.SERIALIZER, output);
            CatalogSerializationUtils.writeArray(entry.schemas, CatalogSchemaDescriptor.SERIALIZER, output);
            output.writeBoolean(entry.defaultZoneId != null);
            if (entry.defaultZoneId != null) {
                output.writeVarInt((long)entry.defaultZoneId.intValue());
            }
        }
    }
}

